/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.helpers.response.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.api.metadata.AdditionalAttributes;
import com.mulesoft.connectors.inference.api.metadata.TokenUsage;
import com.mulesoft.connectors.inference.api.response.TextGenerationResponse;
import com.mulesoft.connectors.inference.api.response.ToolCall;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.TextResponseDTO;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.cohere.CohereChatCompletionResponse;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.cohere.CohereTokenUsage;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.cohere.Content;
import com.mulesoft.connectors.inference.internal.helpers.response.mapper.DefaultResponseMapper;
import java.util.List;
import java.util.Optional;

public class CohereResponseMapper
extends DefaultResponseMapper {
    public CohereResponseMapper(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public TokenUsage mapTokenUsageFromResponse(TextResponseDTO responseDTO) {
        CohereChatCompletionResponse chatCompletionResponse = (CohereChatCompletionResponse)responseDTO;
        CohereTokenUsage chatRespUsage = chatCompletionResponse.usage();
        return new TokenUsage(chatRespUsage.billedUnits().inputTokens(), chatRespUsage.billedUnits().outputTokens(), chatRespUsage.billedUnits().inputTokens() + chatRespUsage.billedUnits().outputTokens());
    }

    @Override
    public AdditionalAttributes mapAdditionalAttributes(TextResponseDTO responseDTO, String modelName) {
        CohereChatCompletionResponse chatCompletionResponse = (CohereChatCompletionResponse)responseDTO;
        return new AdditionalAttributes(chatCompletionResponse.id(), modelName, chatCompletionResponse.finishReason());
    }

    @Override
    public List<ToolCall> mapToolCalls(TextResponseDTO responseDTO) {
        CohereChatCompletionResponse chatCompletionResponse = (CohereChatCompletionResponse)responseDTO;
        return chatCompletionResponse.message().toolCalls();
    }

    @Override
    public TextGenerationResponse mapChatResponse(TextResponseDTO responseDTO) {
        CohereChatCompletionResponse chatCompletionResponse = (CohereChatCompletionResponse)responseDTO;
        Content chatRespFirstChoice = Optional.ofNullable(chatCompletionResponse.message()).flatMap(msg -> Optional.ofNullable(msg.content()).map(contents -> (Content)contents.get(0))).orElse(null);
        return new TextGenerationResponse(Optional.ofNullable(chatRespFirstChoice).map(Content::text).orElse(null), this.mapToolCalls(responseDTO));
    }
}

