/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.operation;

import com.mulesoft.connectors.inference.api.metadata.ImageResponseAttributes;
import com.mulesoft.connectors.inference.internal.connection.types.ImageGenerationConnection;
import com.mulesoft.connectors.inference.internal.error.InferenceErrorType;
import com.mulesoft.connectors.inference.internal.error.provider.ImageGenerationErrorTypeProvider;
import java.io.InputStream;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Throws(value={ImageGenerationErrorTypeProvider.class})
public class ImageGenerationModelOperations {
    @MediaType(value="application/json", strict=false)
    @Alias(value="Generate-image")
    @DisplayName(value="[Image] Generate (only Base64)")
    @OutputJsonType(schema="api/response/ResponseImageGeneration.json")
    public Result<InputStream, ImageResponseAttributes> generateImage(@Connection ImageGenerationConnection connection, @Content String prompt) throws ModuleException {
        try {
            return connection.getService().getImageGenerationServiceInstance().executeGenerateImage(connection, prompt);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException("Error in executing generate image operation.", (ErrorTypeDefinition)InferenceErrorType.IMAGE_GENERATION_FAILURE, (Throwable)e);
        }
    }
}

