/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.operation;

import com.mulesoft.connectors.inference.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.error.InferenceErrorType;
import com.mulesoft.connectors.inference.internal.error.provider.TextGenerationErrorTypeProvider;
import java.io.InputStream;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Throws(value={TextGenerationErrorTypeProvider.class})
public class TextGenerationOperations {
    @MediaType(value="application/json", strict=false)
    @Alias(value="Chat-completions")
    @DisplayName(value="[Chat] Completions")
    @OutputJsonType(schema="api/response/Response.json")
    @Summary(value="Native chat completion operation")
    public Result<InputStream, LLMResponseAttributes> chatCompletion(@Connection TextGenerationConnection connection, @Content InputStream messages) throws ModuleException {
        try {
            return connection.getService().getTextGenerationServiceInstance().executeChatCompletion(connection, messages);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException("Error in executing chat completion", (ErrorTypeDefinition)InferenceErrorType.CHAT_OPERATION_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Chat-answer-prompt")
    @DisplayName(value="[Chat] Answer Prompt")
    @OutputJsonType(schema="api/response/Response.json")
    @Summary(value="Simple chat answer prompt")
    public Result<InputStream, LLMResponseAttributes> chatAnswerPrompt(@Connection TextGenerationConnection connection, @Content String prompt) throws ModuleException {
        try {
            return connection.getService().getTextGenerationServiceInstance().executeChatAnswerPrompt(connection, prompt);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException("Error in executing chat answer prompt", (ErrorTypeDefinition)InferenceErrorType.CHAT_OPERATION_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Agent-define-prompt-template")
    @DisplayName(value="[Agent] Define Prompt Template")
    @OutputJsonType(schema="api/response/Response.json")
    @Summary(value="Define a prompt template with instructions, and data ")
    public Result<InputStream, LLMResponseAttributes> promptTemplate(@Connection TextGenerationConnection connection, @Content String template, @Content String instructions, @Content(primary=true) String data) throws ModuleException {
        try {
            return connection.getService().getTextGenerationServiceInstance().definePromptTemplate(connection, template, instructions, data);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException("Error in executing define prompt template", (ErrorTypeDefinition)InferenceErrorType.CHAT_OPERATION_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Tools-native-template")
    @DisplayName(value="[Tools] Native Template (Reasoning only)")
    @OutputJsonType(schema="api/response/Response.json")
    @Summary(value="[Tools] Native Template (Reasoning only)")
    public Result<InputStream, LLMResponseAttributes> toolsTemplate(@Connection TextGenerationConnection connection, @Content String template, @Content String instructions, @Content(primary=true) String data, @Content @Summary(value="JSON Array defining the tools set to be used in the template so that the LLM can use them if required") InputStream tools) throws ModuleException {
        try {
            return connection.getService().getTextGenerationServiceInstance().executeToolsNativeTemplate(connection, template, instructions, data, tools);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException("Error in executing operation Tools native template", (ErrorTypeDefinition)InferenceErrorType.TOOLS_OPERATION_FAILURE, (Throwable)e);
        }
    }
}

