/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.operation;

import com.mulesoft.connectors.inference.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.inference.internal.connection.types.VisionModelConnection;
import com.mulesoft.connectors.inference.internal.error.InferenceErrorType;
import com.mulesoft.connectors.inference.internal.error.provider.VisionErrorTypeProvider;
import java.io.InputStream;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Throws(value={VisionErrorTypeProvider.class})
public class VisionModelOperations {
    @MediaType(value="application/json", strict=false)
    @Alias(value="Read-image")
    @DisplayName(value="[Image] Read by (Url or Base64)")
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> readImage(@Connection VisionModelConnection connection, @Content String prompt, @Content(primary=true) @DisplayName(value="Image") @Summary(value="An Image URL or a Base64 Image") String imageUrl) throws ModuleException {
        try {
            return connection.getService().getVisionModelServiceInstance().readImage(connection, prompt, imageUrl);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException("Error in executing read image operation", (ErrorTypeDefinition)InferenceErrorType.READ_IMAGE_OPERATION_FAILURE, (Throwable)e);
        }
    }
}

