/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.inference.internal.connection.types.VisionModelConnection;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.TextResponseDTO;
import com.mulesoft.connectors.inference.internal.dto.vision.VisionRequestPayloadDTO;
import com.mulesoft.connectors.inference.internal.error.InferenceErrorType;
import com.mulesoft.connectors.inference.internal.helpers.ResponseHelper;
import com.mulesoft.connectors.inference.internal.helpers.payload.RequestPayloadHelper;
import com.mulesoft.connectors.inference.internal.helpers.request.HttpRequestHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.HttpResponseHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.mapper.DefaultResponseMapper;
import com.mulesoft.connectors.inference.internal.service.BaseService;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisionModelService
implements BaseService {
    private static final Logger logger = LoggerFactory.getLogger(VisionModelService.class);
    private final RequestPayloadHelper payloadHelper;
    private final HttpRequestHelper httpRequestHelper;
    private final HttpResponseHelper responseHelper;
    private final DefaultResponseMapper responseParser;
    private final ObjectMapper objectMapper;

    public VisionModelService(RequestPayloadHelper requestPayloadHelper, HttpRequestHelper httpRequestHelper, HttpResponseHelper responseHelper, DefaultResponseMapper responseParser, ObjectMapper objectMapper) {
        this.payloadHelper = requestPayloadHelper;
        this.httpRequestHelper = httpRequestHelper;
        this.responseHelper = responseHelper;
        this.responseParser = responseParser;
        this.objectMapper = objectMapper;
    }

    public Result<InputStream, LLMResponseAttributes> readImage(VisionModelConnection connection, String prompt, String imageUrl) throws IOException, TimeoutException {
        VisionRequestPayloadDTO visionPayload = this.payloadHelper.createRequestImageURL(connection, prompt, imageUrl);
        logger.debug("payload sent to the LLM {}", (Object)visionPayload);
        HttpResponse response = this.httpRequestHelper.executeVisionRestRequest(connection, connection.getApiURL(), visionPayload);
        TextResponseDTO chatResponse = this.responseHelper.processChatResponse(response, InferenceErrorType.READ_IMAGE_OPERATION_FAILURE);
        logger.debug("Response of vision REST request: {}", (Object)chatResponse);
        return ResponseHelper.createLLMResponse(this.objectMapper.writeValueAsString((Object)this.responseParser.mapChatResponse(chatResponse)), this.responseParser.mapTokenUsageFromResponse(chatResponse), this.responseParser.mapAdditionalAttributes(chatResponse, connection.getModelName()));
    }
}

