/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider.huggingface;

import com.mulesoft.connectors.inference.internal.connection.parameters.BaseConnectionParameters;
import com.mulesoft.connectors.inference.internal.connection.provider.ImageGenerationConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.huggingface.HuggingFaceImageGenerationConnection;
import com.mulesoft.connectors.inference.internal.llmmodels.huggingface.providers.HuggingFaceImageGenerationModelNameProvider;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="hugging-face-image")
@DisplayName(value="Hugging Face")
public class HuggingFaceImageConnectionProvider
extends ImageGenerationConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(HuggingFaceImageConnectionProvider.class);
    public static final String HUGGINGFACE_URL = "https://router.huggingface.co/hf-inference";
    public static final String URI_GENERATE_IMAGES = "/models/{model-name}";
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=HuggingFaceImageGenerationModelNameProvider.class)
    @Placement(order=1)
    private String huggingFaceModelName;
    @ParameterGroup(name="Connection")
    private BaseConnectionParameters baseConnectionParameters;

    public HuggingFaceImageGenerationConnection connect() {
        logger.debug("BaseConnection connect ...");
        return new HuggingFaceImageGenerationConnection(this.getHttpClient(), this.getObjectMapper(), this.huggingFaceModelName, this.baseConnectionParameters.getApiKey(), this.baseConnectionParameters.getCustomHeaders(), this.baseConnectionParameters.getTimeout(), this.getImageGenerationAPIURL(this.huggingFaceModelName));
    }

    private String getImageGenerationAPIURL(String huggingFaceModelName) {
        String urlStr = "https://router.huggingface.co/hf-inference/models/{model-name}";
        urlStr = urlStr.replace("{model-name}", huggingFaceModelName);
        return urlStr;
    }
}

