/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider.lmstudio;

import com.mulesoft.connectors.inference.internal.connection.parameters.TextGenerationConnectionParameters;
import com.mulesoft.connectors.inference.internal.connection.provider.TextGenerationConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.lmstudio.LMStudioTextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.llmmodels.lmstudio.providers.LMStudioTextGenerationModelNameProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="lmstudio")
@DisplayName(value="LM Studio")
public class LMStudioTextGenerationConnectionProvider
extends TextGenerationConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(LMStudioTextGenerationConnectionProvider.class);
    @Parameter
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=LMStudioTextGenerationModelNameProvider.class)
    private String lmStudioModelName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="http://localhost:1234/v1")
    @Placement(order=2)
    @DisplayName(value="[LM Studio] Base URL")
    private String lmStudioBaseURL;
    @ParameterGroup(name="Connection")
    private TextGenerationConnectionParameters textGenerationConnectionParameters;

    public LMStudioTextGenerationConnection connect() throws ConnectionException {
        logger.debug("LMStudioTextGenerationConnection connect ...");
        return new LMStudioTextGenerationConnection(this.getHttpClient(), this.getObjectMapper(), new ParametersDTO(this.lmStudioModelName, this.textGenerationConnectionParameters.getApiKey(), this.textGenerationConnectionParameters.getMaxTokens(), this.textGenerationConnectionParameters.getTemperature(), this.textGenerationConnectionParameters.getTopP(), this.textGenerationConnectionParameters.getTimeout(), this.textGenerationConnectionParameters.getCustomHeaders()), this.lmStudioBaseURL);
    }
}

