/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider.ollama;

import com.mulesoft.connectors.inference.internal.connection.parameters.TextGenerationConnectionParameters;
import com.mulesoft.connectors.inference.internal.connection.provider.TextGenerationConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.ollama.OllamaTextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.llmmodels.ollama.providers.OllamaTextGenerationModelNameProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="ollama")
@DisplayName(value="Ollama")
public class OllamaTextGenerationConnectionProvider
extends TextGenerationConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(OllamaTextGenerationConnectionProvider.class);
    @Parameter
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=OllamaTextGenerationModelNameProvider.class)
    private String ollamaModelName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="http://localhost:11434/api")
    @Placement(order=2)
    @DisplayName(value="[Ollama] Base URL")
    private String ollamaUrl;
    @ParameterGroup(name="Connection")
    private TextGenerationConnectionParameters textGenerationConnectionParameters;

    public OllamaTextGenerationConnection connect() throws ConnectionException {
        logger.debug("OllamaTextGenerationConnection connect ...");
        return new OllamaTextGenerationConnection(this.getHttpClient(), this.getObjectMapper(), new ParametersDTO(this.ollamaModelName, this.textGenerationConnectionParameters.getApiKey(), this.textGenerationConnectionParameters.getMaxTokens(), this.textGenerationConnectionParameters.getTemperature(), this.textGenerationConnectionParameters.getTopP(), this.textGenerationConnectionParameters.getTimeout(), this.textGenerationConnectionParameters.getCustomHeaders()), this.ollamaUrl);
    }
}

