/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider.openai;

import com.mulesoft.connectors.inference.internal.connection.parameters.BaseConnectionParameters;
import com.mulesoft.connectors.inference.internal.connection.provider.ModerationConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.ModerationConnection;
import com.mulesoft.connectors.inference.internal.llmmodels.openai.providers.OpenAIModerationModelNameProvider;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="openai-moderation")
@DisplayName(value="OpenAI")
public class OpenAIModerationConnectionProvider
extends ModerationConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(OpenAIModerationConnectionProvider.class);
    public static final String OPEN_AI_URL = "https://api.openai.com/v1";
    public static final String MODERATIONS_PATH = "/moderations";
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=OpenAIModerationModelNameProvider.class)
    @Placement(order=1)
    private String openAIModelName;
    @ParameterGroup(name="Connection")
    private BaseConnectionParameters baseConnectionParameters;

    public ModerationConnection connect() {
        logger.debug("ModerationConnection connect ...");
        return new ModerationConnection(this.getHttpClient(), this.getObjectMapper(), this.baseConnectionParameters.getApiKey(), this.baseConnectionParameters.getCustomHeaders(), this.openAIModelName, this.baseConnectionParameters.getTimeout(), this.getModerationAPIURL());
    }

    private String getModerationAPIURL() {
        return "https://api.openai.com/v1/moderations";
    }
}

