/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider.openai;

import com.mulesoft.connectors.inference.internal.connection.parameters.TextGenerationConnectionParameters;
import com.mulesoft.connectors.inference.internal.connection.provider.TextGenerationConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.openai.OpenAITextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.llmmodels.openai.providers.OpenAITextGenerationModelNameProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="openai")
@DisplayName(value="OpenAI")
public class OpenAITextGenerationConnectionProvider
extends TextGenerationConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(OpenAITextGenerationConnectionProvider.class);
    @Parameter
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=OpenAITextGenerationModelNameProvider.class)
    @Optional(defaultValue="gpt-4o-mini")
    private String openAIModelName;
    @ParameterGroup(name="Connection")
    private TextGenerationConnectionParameters openAITextGenerationConnectionParameters;

    public OpenAITextGenerationConnection connect() throws ConnectionException {
        logger.debug("OpenAITextGenerationConnection connect ...");
        return new OpenAITextGenerationConnection(this.getHttpClient(), this.getObjectMapper(), new ParametersDTO(this.openAIModelName, this.openAITextGenerationConnectionParameters.getApiKey(), this.openAITextGenerationConnectionParameters.getMaxTokens(), this.openAITextGenerationConnectionParameters.getTemperature(), this.openAITextGenerationConnectionParameters.getTopP(), this.openAITextGenerationConnectionParameters.getTimeout(), this.openAITextGenerationConnectionParameters.getCustomHeaders()));
    }
}

