/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.types;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.BaseConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.service.VisionModelService;
import org.mule.runtime.http.api.client.HttpClient;

public class VisionModelConnection
extends BaseConnection {
    private final Number maxTokens;
    private final Number temperature;
    private final Number topP;
    private VisionModelService visionModelService;

    protected VisionModelConnection(HttpClient httpClient, ObjectMapper objectMapper, ParametersDTO parametersDTO, String apiUrl) {
        super(httpClient, objectMapper, parametersDTO.modelName(), parametersDTO.apiKey(), parametersDTO.customHeaders(), parametersDTO.timeout(), apiUrl);
        this.maxTokens = parametersDTO.maxTokens();
        this.temperature = parametersDTO.temperature();
        this.topP = parametersDTO.topP();
        this.setBaseService(this.getVisionModelService());
    }

    public Number getMaxTokens() {
        return this.maxTokens;
    }

    public Number getTemperature() {
        return this.temperature;
    }

    public Number getTopP() {
        return this.topP;
    }

    public VisionModelService getVisionModelService() {
        if (this.visionModelService == null) {
            this.visionModelService = new VisionModelService(this.getRequestPayloadHelper(), this.getHttpRequestHelper(), this.getResponseHelper(), this.getResponseMapper(), this.getObjectMapper());
        }
        return this.visionModelService;
    }
}

