/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.types.anthropic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.helpers.payload.AnthropicRequestPayloadHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.AnthropicHttpResponseHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.mapper.AnthropicResponseMapper;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.http.api.client.HttpClient;

public class AnthropicTextGenerationConnection
extends TextGenerationConnection {
    private static final String URI_CHAT_COMPLETIONS = "/messages";
    public static final String ANTHROPIC_URL = "https://api.anthropic.com/v1";
    private AnthropicRequestPayloadHelper requestPayloadHelper;
    private AnthropicResponseMapper responseMapper;
    private AnthropicHttpResponseHelper httpResponseHelper;

    public AnthropicTextGenerationConnection(HttpClient httpClient, ObjectMapper objectMapper, ParametersDTO parametersDTO) {
        super(httpClient, objectMapper, parametersDTO, AnthropicTextGenerationConnection.fetchApiURL());
    }

    @Override
    public AnthropicRequestPayloadHelper getRequestPayloadHelper() {
        if (this.requestPayloadHelper == null) {
            this.requestPayloadHelper = new AnthropicRequestPayloadHelper(this.getObjectMapper());
        }
        return this.requestPayloadHelper;
    }

    @Override
    public AnthropicResponseMapper getResponseMapper() {
        if (this.responseMapper == null) {
            this.responseMapper = new AnthropicResponseMapper(this.getObjectMapper());
        }
        return this.responseMapper;
    }

    @Override
    public AnthropicHttpResponseHelper getResponseHelper() {
        if (this.httpResponseHelper == null) {
            this.httpResponseHelper = new AnthropicHttpResponseHelper(this.getObjectMapper());
        }
        return this.httpResponseHelper;
    }

    @Override
    public Map<String, String> getAdditionalHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-api-key", this.getApiKey());
        headers.put("anthropic-version", "2023-06-01");
        headers.putAll(this.getCustomHeadersMap());
        return headers;
    }

    private static String fetchApiURL() {
        return "https://api.anthropic.com/v1/messages";
    }
}

