/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.types.azure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.http.api.client.HttpClient;

public class AzureAIFoundryTextGenerationConnection
extends TextGenerationConnection {
    private static final String URI_CHAT_COMPLETIONS = "/chat/completions?api-version={api-version}";
    public static final String AZURE_AI_FOUNDRY_URL = "https://{resource-name}.services.ai.azure.com/models";

    public AzureAIFoundryTextGenerationConnection(HttpClient httpClient, ObjectMapper objectMapper, ParametersDTO parametersDTO, String azureAIFoundryResourceName, String azureAIFoundryApiVersion) {
        super(httpClient, objectMapper, parametersDTO, AzureAIFoundryTextGenerationConnection.fetchApiURL(azureAIFoundryResourceName, azureAIFoundryApiVersion));
    }

    @Override
    public Map<String, String> getAdditionalHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("api-key", this.getApiKey());
        headers.putAll(this.getCustomHeadersMap());
        return headers;
    }

    private static String fetchApiURL(String azureAIFoundryResourceName, String azureAIFoundryApiVersion) {
        String aifurlStr = "https://{resource-name}.services.ai.azure.com/models/chat/completions?api-version={api-version}";
        aifurlStr = aifurlStr.replace("{resource-name}", azureAIFoundryResourceName).replace("{api-version}", azureAIFoundryApiVersion);
        return aifurlStr;
    }
}

