/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.types.portkey;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.VisionModelConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.http.api.client.HttpClient;

public class PortkeyVisionConnection
extends VisionModelConnection {
    private static final String URI_CHAT_COMPLETIONS = "/chat/completions";
    public static final String PORTKEY_URL = "https://api.portkey.ai/v1";
    private final String virtualKey;

    public PortkeyVisionConnection(HttpClient httpClient, ObjectMapper objectMapper, ParametersDTO parametersDTO, String virtualKey) {
        super(httpClient, objectMapper, parametersDTO, PortkeyVisionConnection.fetchApiURL());
        this.virtualKey = virtualKey;
    }

    @Override
    public Map<String, String> getAdditionalHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-portkey-api-key", this.getApiKey());
        headers.put("x-portkey-virtual-key", this.virtualKey);
        headers.putAll(this.getCustomHeadersMap());
        return headers;
    }

    private static String fetchApiURL() {
        return "https://api.portkey.ai/v1/chat/completions";
    }
}

