/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.helpers;

import com.mulesoft.connectors.inference.api.metadata.AdditionalAttributes;
import com.mulesoft.connectors.inference.api.metadata.ImageResponseAttributes;
import com.mulesoft.connectors.inference.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.inference.api.metadata.TokenUsage;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class ResponseHelper {
    private ResponseHelper() {
    }

    public static Result<InputStream, LLMResponseAttributes> createLLMResponse(String response, TokenUsage tokenUsage, AdditionalAttributes responseAttributes) {
        return Result.builder().attributes((Object)new LLMResponseAttributes(tokenUsage, responseAttributes)).attributesMediaType(MediaType.APPLICATION_JAVA).output((Object)IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_JSON).build();
    }

    public static Result<InputStream, Void> createLLMResponse(String response) {
        return Result.builder().output((Object)IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_JSON).build();
    }

    public static Result<InputStream, ImageResponseAttributes> createImageGenerationLLMResponse(String response, String model, String revisedPrompt) {
        return Result.builder().attributes((Object)new ImageResponseAttributes(model, revisedPrompt)).attributesMediaType(MediaType.APPLICATION_JAVA).output((Object)IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_JSON).build();
    }
}

