/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.helpers.payload;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.api.request.ChatPayloadRecord;
import com.mulesoft.connectors.inference.api.request.FunctionDefinitionRecord;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.connection.types.VisionModelConnection;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.OllamaRequestPayloadRecord;
import com.mulesoft.connectors.inference.internal.dto.vision.DefaultVisionRequestPayloadRecord;
import com.mulesoft.connectors.inference.internal.dto.vision.OllamaMessageRecord;
import com.mulesoft.connectors.inference.internal.helpers.payload.RequestPayloadHelper;
import java.util.List;
import java.util.Map;

public class OllamaRequestPayloadHelper
extends RequestPayloadHelper {
    public OllamaRequestPayloadHelper(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public OllamaRequestPayloadRecord buildPayload(TextGenerationConnection connection, List<ChatPayloadRecord> messagesArray, List<FunctionDefinitionRecord> tools, Map<String, Object> additionalRequestAttributes) {
        return new OllamaRequestPayloadRecord(connection.getModelName(), messagesArray, connection.getMaxTokens(), connection.getTemperature(), connection.getTopP(), false, tools, additionalRequestAttributes);
    }

    @Override
    public DefaultVisionRequestPayloadRecord createRequestImageURL(VisionModelConnection connection, String prompt, String imageUrl, Map<String, Object> additionalRequestAttributes) {
        return new DefaultVisionRequestPayloadRecord(connection.getModelName(), List.of(new OllamaMessageRecord("user", prompt, List.of(imageUrl))), connection.getMaxTokens(), connection.getTemperature(), connection.getTopP(), additionalRequestAttributes);
    }
}

