/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.helpers.request;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.BaseConnection;
import com.mulesoft.connectors.inference.internal.connection.types.ImageGenerationConnection;
import com.mulesoft.connectors.inference.internal.connection.types.ModerationConnection;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.connection.types.VisionModelConnection;
import com.mulesoft.connectors.inference.internal.dto.imagegeneration.ImageGenerationRequestPayloadDTO;
import com.mulesoft.connectors.inference.internal.dto.moderation.ModerationRequestPayloadRecord;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.TextGenerationRequestPayloadDTO;
import com.mulesoft.connectors.inference.internal.dto.vision.VisionRequestPayloadDTO;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestHelper {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestHelper.class);
    protected final HttpClient httpClient;
    protected final ObjectMapper objectMapper;

    public HttpRequestHelper(HttpClient httpClient, ObjectMapper objectMapper) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    public HttpResponse executeChatRestRequest(TextGenerationConnection connection, String resourceUrl, TextGenerationRequestPayloadDTO payload) throws IOException, TimeoutException {
        return this.executeRestRequest(connection, resourceUrl, connection.getObjectMapper().writeValueAsBytes((Object)payload));
    }

    public HttpResponse executeImageGenerationRestRequest(ImageGenerationConnection connection, String resourceUrl, ImageGenerationRequestPayloadDTO payload) throws IOException, TimeoutException {
        return this.executeRestRequest(connection, resourceUrl, connection.getObjectMapper().writeValueAsBytes((Object)payload));
    }

    public HttpResponse executeVisionRestRequest(VisionModelConnection connection, String resourceUrl, VisionRequestPayloadDTO payload) throws IOException, TimeoutException {
        return this.executeRestRequest(connection, resourceUrl, connection.getObjectMapper().writeValueAsBytes((Object)payload));
    }

    public HttpResponse executeModerationRestRequest(ModerationConnection connection, String resourceUrl, ModerationRequestPayloadRecord payload) throws IOException, TimeoutException {
        return this.executeRestRequest(connection, resourceUrl, connection.getObjectMapper().writeValueAsBytes((Object)payload));
    }

    private HttpResponse executeRestRequest(BaseConnection connection, String resourceUrl, byte[] payloadAsBytes) throws IOException, TimeoutException {
        HttpRequestBuilder requestBuilder = (HttpRequestBuilder)((HttpRequestBuilder)this.createDefaultRequestBuilder(resourceUrl).headers(new MultiMap(connection.getAdditionalHeaders()))).queryParams(new MultiMap(connection.getQueryParams())).entity((HttpEntity)new ByteArrayHttpEntity(payloadAsBytes));
        logger.debug("Sending request to URL: {}", (Object)resourceUrl);
        logger.trace("Request headers: {}", (Object)requestBuilder.getHeaders());
        logger.trace("Request queryParams: {}", (Object)requestBuilder.getQueryParams());
        HttpRequestOptions options = this.getRequestOptions(connection.getTimeout());
        return this.httpClient.send(requestBuilder.build(), options);
    }

    private HttpRequestBuilder createDefaultRequestBuilder(String url) {
        return (HttpRequestBuilder)HttpRequest.builder().uri(url).method("POST").headers(this.getDefaultHeaders());
    }

    private MultiMap<String, String> getDefaultHeaders() {
        return new MultiMap(Map.of("Content-Type", "application/json", "Accept", "application/json"));
    }

    private HttpRequestOptions getRequestOptions(int timeout) {
        return HttpRequestOptions.builder().responseTimeout(timeout).followsRedirect(true).build();
    }
}

