/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.helpers.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.gemini.GeminiChatCompletionResponse;
import com.mulesoft.connectors.inference.internal.error.InferenceErrorType;
import com.mulesoft.connectors.inference.internal.helpers.response.HttpResponseHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiHttpResponseHelper
extends HttpResponseHelper {
    private static final Logger logger = LoggerFactory.getLogger(GeminiHttpResponseHelper.class);

    public GeminiHttpResponseHelper(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public GeminiChatCompletionResponse processChatResponse(HttpResponse response, InferenceErrorType errorType) throws IOException {
        logger.debug("Processing Gemini chat response. Response Code:{}", (Object)response.getStatusCode());
        int statusCode = response.getStatusCode();
        if (statusCode == 200) {
            String responseBody = new String(response.getEntity().getBytes(), StandardCharsets.UTF_8);
            logger.debug("Gemini raw JSON response:\n{}", (Object)responseBody);
            GeminiChatCompletionResponse geminiResponse = (GeminiChatCompletionResponse)this.objectMapper.readValue(responseBody, GeminiChatCompletionResponse.class);
            logger.debug("Gemini response: {}", (Object)geminiResponse);
            return geminiResponse;
        }
        throw this.handleErrorResponse(response, statusCode, errorType);
    }
}

