/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.api.mcp.McpConfig;
import com.mulesoft.connectors.inference.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.inference.api.request.FunctionDefinitionRecord;
import com.mulesoft.connectors.inference.api.response.ToolResult;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.mcp.McpToolRecord;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.TextGenerationRequestPayloadDTO;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.TextResponseDTO;
import com.mulesoft.connectors.inference.internal.error.InferenceErrorType;
import com.mulesoft.connectors.inference.internal.helpers.ResponseHelper;
import com.mulesoft.connectors.inference.internal.helpers.mcp.McpHelper;
import com.mulesoft.connectors.inference.internal.helpers.payload.RequestPayloadHelper;
import com.mulesoft.connectors.inference.internal.helpers.request.HttpRequestHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.HttpResponseHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.mapper.DefaultResponseMapper;
import com.mulesoft.connectors.inference.internal.service.BaseService;
import com.mulesoft.connectors.inference.internal.utils.ParseUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextGenerationService
implements BaseService {
    private static final Logger logger = LoggerFactory.getLogger(TextGenerationService.class);
    public static final String PAYLOAD_LOGGER_MSG = "Payload sent to the LLM {}";
    private final RequestPayloadHelper payloadHelper;
    private final HttpRequestHelper httpRequestHelper;
    private final HttpResponseHelper responseHelper;
    private final DefaultResponseMapper responseParser;
    private final McpHelper mcpHelper;
    private final ObjectMapper objectMapper;

    public TextGenerationService(RequestPayloadHelper requestPayloadHelper, HttpRequestHelper httpRequestHelper, HttpResponseHelper responseHelper, DefaultResponseMapper responseParser, McpHelper mcpHelper, ObjectMapper objectMapper) {
        this.payloadHelper = requestPayloadHelper;
        this.httpRequestHelper = httpRequestHelper;
        this.responseHelper = responseHelper;
        this.responseParser = responseParser;
        this.mcpHelper = mcpHelper;
        this.objectMapper = objectMapper;
    }

    public Result<InputStream, LLMResponseAttributes> executeChatAnswerPrompt(TextGenerationConnection connection, String prompt, InputStream additionalRequestAttributes) throws IOException, TimeoutException {
        return this.executeChatRequestAndFormatResponse(connection, this.payloadHelper.buildChatAnswerPromptPayload(connection, prompt, ParseUtils.parseAdditionalRequestAttributes(additionalRequestAttributes, this.objectMapper)));
    }

    public Result<InputStream, LLMResponseAttributes> executeChatCompletion(TextGenerationConnection connection, InputStream messages, InputStream additionalRequestAttributes) throws IOException, TimeoutException {
        TextGenerationRequestPayloadDTO requestPayloadDTO = this.payloadHelper.parseAndBuildChatCompletionPayload(connection, messages, ParseUtils.parseAdditionalRequestAttributes(additionalRequestAttributes, this.objectMapper));
        return this.executeChatRequestAndFormatResponse(connection, requestPayloadDTO);
    }

    public Result<InputStream, LLMResponseAttributes> definePromptTemplate(TextGenerationConnection connection, String template, String instructions, String data, InputStream additionalRequestAttributes) throws IOException, TimeoutException {
        return this.executeChatRequestAndFormatResponse(connection, this.payloadHelper.buildPromptTemplatePayload(connection, template, instructions, data, ParseUtils.parseAdditionalRequestAttributes(additionalRequestAttributes, this.objectMapper)));
    }

    public Result<InputStream, LLMResponseAttributes> executeToolsNativeTemplate(TextGenerationConnection connection, String template, String instructions, String data, InputStream tools, InputStream additionalRequestAttributes) throws IOException, TimeoutException {
        return this.executeToolsRequestAndFormatResponse(connection, this.payloadHelper.buildToolsTemplatePayload(connection, template, instructions, data, tools, ParseUtils.parseAdditionalRequestAttributes(additionalRequestAttributes, this.objectMapper)));
    }

    public Result<InputStream, LLMResponseAttributes> executeMcpTools(TextGenerationConnection connection, Scheduler scheduler, ExtensionsClient extensionsClient, List<McpConfig> mcpConfigs, String template, String instructions, String data, InputStream additionalRequestAttributes) {
        return (Result)((CompletableFuture)((CompletableFuture)this.mcpHelper.getTools(mcpConfigs, scheduler, extensionsClient).thenApply(collectedTools -> {
            try {
                List<FunctionDefinitionRecord> toolFunctions = collectedTools.values().stream().map(mcpTool -> new FunctionDefinitionRecord("function", mcpTool.function())).toList();
                TextGenerationRequestPayloadDTO requestPayloadDTO = this.payloadHelper.buildToolsTemplatePayload(connection, template, instructions, data, toolFunctions, ParseUtils.parseAdditionalRequestAttributes(additionalRequestAttributes, this.objectMapper));
                logger.debug(PAYLOAD_LOGGER_MSG, (Object)requestPayloadDTO);
                TextResponseDTO chatResponse = this.executeChatRequest(connection, requestPayloadDTO);
                List<ToolResult> toolExecutionResult = this.mcpHelper.executeTools((Map<String, McpToolRecord>)collectedTools, this.responseParser.mapToolCalls(chatResponse, null), extensionsClient);
                logger.debug("Tool Execution result:{}", toolExecutionResult);
                return ResponseHelper.createLLMResponse(this.objectMapper.writeValueAsString((Object)this.responseParser.mapMcpExecuteToolsResponse(chatResponse, toolExecutionResult, (Map<String, McpToolRecord>)collectedTools)), this.responseParser.mapTokenUsageFromResponse(chatResponse), this.responseParser.mapAdditionalAttributes(chatResponse, connection.getModelName()));
            }
            catch (Exception e) {
                throw new ModuleException("Error processing MCP tools", (ErrorTypeDefinition)InferenceErrorType.MCP_SERVER_ERROR, (Throwable)e);
            }
        })).exceptionally(throwable -> {
            Throwable cause = throwable.getCause() != null ? throwable.getCause() : throwable;
            throw new ModuleException("Error in getting MCP tools", (ErrorTypeDefinition)InferenceErrorType.MCP_SERVER_ERROR, cause);
        })).join();
    }

    private Result<InputStream, LLMResponseAttributes> executeToolsRequestAndFormatResponse(TextGenerationConnection connection, TextGenerationRequestPayloadDTO requestPayloadDTO) throws IOException, TimeoutException {
        return this.executeChatRequestAndFormatResponse(connection, requestPayloadDTO);
    }

    private Result<InputStream, LLMResponseAttributes> executeChatRequestAndFormatResponse(TextGenerationConnection connection, TextGenerationRequestPayloadDTO requestPayloadDTO) throws IOException, TimeoutException {
        TextResponseDTO chatResponse = this.executeChatRequest(connection, requestPayloadDTO);
        return ResponseHelper.createLLMResponse(this.objectMapper.writeValueAsString((Object)this.responseParser.mapChatResponse(chatResponse)), this.responseParser.mapTokenUsageFromResponse(chatResponse), this.responseParser.mapAdditionalAttributes(chatResponse, connection.getModelName()));
    }

    private TextResponseDTO executeChatRequest(TextGenerationConnection connection, TextGenerationRequestPayloadDTO requestPayloadDTO) throws IOException, TimeoutException {
        logger.debug("Request payload: {} ", (Object)requestPayloadDTO);
        HttpResponse response = this.httpRequestHelper.executeChatRestRequest(connection, connection.getApiURL(), requestPayloadDTO);
        TextResponseDTO chatResponse = this.responseHelper.processChatResponse(response, InferenceErrorType.CHAT_OPERATION_FAILURE);
        logger.debug("Response of chat REST request: {}", (Object)chatResponse);
        return chatResponse;
    }
}

