/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.parameters;

import com.mulesoft.connectors.inference.api.request.RequestHeader;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class BaseConnectionParameters {
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="API Key")
    @Placement(order=1)
    private String apiKey;
    @Parameter
    @Optional
    @NullSafe
    @DisplayName(value="Custom headers")
    @Summary(value="Custom headers that can be included in every single request sent.")
    @Placement(order=2)
    private List<RequestHeader> customHeaders;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Timeout")
    @Placement(tab="Advanced", order=1)
    @Optional(defaultValue="60")
    private int timeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Placement(tab="Advanced", order=2)
    private TimeUnit timeoutUnit;

    public String getApiKey() {
        return this.apiKey;
    }

    public List<RequestHeader> getCustomHeaders() {
        return this.customHeaders;
    }

    public int getTimeout() {
        return Math.toIntExact(this.getTimeoutUnit().toMillis(this.timeout));
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }
}

