/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider;

import com.mulesoft.connectors.inference.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.inference.api.response.TextGenerationResponse;
import com.mulesoft.connectors.inference.internal.connection.provider.BaseConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.error.InferenceErrorType;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TextGenerationConnectionProvider
extends BaseConnectionProvider
implements CachedConnectionProvider<TextGenerationConnection>,
Initialisable,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(TextGenerationConnectionProvider.class);

    public ConnectionValidationResult validate(TextGenerationConnection connection) {
        logger.debug("Validating TextGenerationConnection ... ");
        try {
            Result<InputStream, LLMResponseAttributes> resp = connection.getTextGenerationService().executeChatAnswerPrompt(connection, "What is the capital of France?", null);
            TextGenerationResponse textResponse = (TextGenerationResponse)this.getObjectMapper().readValue((InputStream)resp.getOutput(), TextGenerationResponse.class);
            if (textResponse.response().contains("Paris")) {
                return ConnectionValidationResult.success();
            }
        }
        catch (IOException | TimeoutException | ModuleException e) {
            return ConnectionValidationResult.failure((String)"Failed to validate TextGenerationConnection", (Exception)((Object)new ModuleException("Error validating connection.", (ErrorTypeDefinition)InferenceErrorType.INVALID_CONNECTION, e)));
        }
        return ConnectionValidationResult.failure((String)"Failed to validate TextGenerationConnection", (Exception)((Object)new ModuleException("Error validating connection.", (ErrorTypeDefinition)InferenceErrorType.INVALID_CONNECTION)));
    }

    public void disconnect(TextGenerationConnection baseConnection) {
        logger.debug("TextGenerationConnection disconnected ...");
    }
}

