/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider.azure;

import com.mulesoft.connectors.inference.internal.connection.parameters.AzureOpenAIConnectionParameters;
import com.mulesoft.connectors.inference.internal.connection.parameters.TextGenerationConnectionParameters;
import com.mulesoft.connectors.inference.internal.connection.provider.TextGenerationConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.azure.AzureOpenAITextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.llmmodels.azure.providers.AzureOpenAITextGenerationModelNameProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="azure-openai")
@DisplayName(value="Azure OpenAI")
public class AzureOpenAITextGenerationConnectionProvider
extends TextGenerationConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(AzureOpenAITextGenerationConnectionProvider.class);
    @Parameter
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=AzureOpenAITextGenerationModelNameProvider.class)
    private String azureModelName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="2024-10-21")
    @DisplayName(value="[Azure OpenAI] API Version")
    @Placement(order=5)
    private String azureOpenaiApiVersion;
    @ParameterGroup(name="Required: Enter URL or Parameters")
    private AzureOpenAIConnectionParameters azureOpenAIConnectionParameters;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional
    @DisplayName(value="[Azure OpenAI] User")
    @Summary(value="A unique identifier representing your end-user, which can help to monitor and detect abuse.")
    @Placement(tab="Advanced", order=1)
    private String azureOpenaiUser;
    @ParameterGroup(name="Connection")
    private TextGenerationConnectionParameters textGenerationConnectionParameters;

    public AzureOpenAITextGenerationConnection connect() throws ConnectionException {
        logger.debug("AzureTextGenerationConnection connect ...");
        return new AzureOpenAITextGenerationConnection(this.getHttpClient(), this.getObjectMapper(), new ParametersDTO(this.azureModelName, this.textGenerationConnectionParameters.getApiKey(), this.textGenerationConnectionParameters.getMaxTokens(), this.textGenerationConnectionParameters.getTemperature(), this.textGenerationConnectionParameters.getTopP(), this.textGenerationConnectionParameters.getTimeout(), this.textGenerationConnectionParameters.getCustomHeaders()), this.azureOpenAIConnectionParameters.getAzureOpenAiEndpoint(), this.azureOpenAIConnectionParameters.getAzureOpenaiResourceName(), this.azureOpenAIConnectionParameters.getAzureOpenaiDeploymentId(), this.azureOpenaiApiVersion, this.azureOpenaiUser);
    }
}

