/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider.nvidia;

import com.mulesoft.connectors.inference.internal.connection.parameters.TextGenerationConnectionParameters;
import com.mulesoft.connectors.inference.internal.connection.provider.TextGenerationConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.nvidia.NvidiaTextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.llmmodels.nvidia.providers.NvidiaTextGenerationModelNameProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="nvidia")
@DisplayName(value="NVIDIA")
public class NvidiaTextGenerationConnectionProvider
extends TextGenerationConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(NvidiaTextGenerationConnectionProvider.class);
    @Parameter
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=NvidiaTextGenerationModelNameProvider.class)
    @DisplayName(value="NVIDIA Model Name")
    private String nvidiaModelName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="https://integrate.api.nvidia.com")
    @Placement(order=2)
    @DisplayName(value="NVIDIA Base URL")
    private String nvidiaUrl;
    @ParameterGroup(name="Connection")
    private TextGenerationConnectionParameters textGenerationConnectionParameters;

    public NvidiaTextGenerationConnection connect() throws ConnectionException {
        logger.debug("NvidiaTextGenerationConnection connect ...");
        return new NvidiaTextGenerationConnection(this.getHttpClient(), this.getObjectMapper(), new ParametersDTO(this.nvidiaModelName, this.textGenerationConnectionParameters.getApiKey(), this.textGenerationConnectionParameters.getMaxTokens(), this.textGenerationConnectionParameters.getTemperature(), this.textGenerationConnectionParameters.getTopP(), this.textGenerationConnectionParameters.getTimeout(), this.textGenerationConnectionParameters.getCustomHeaders()), this.nvidiaUrl);
    }
}

