/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider.openai;

import com.mulesoft.connectors.inference.internal.connection.parameters.BaseConnectionParameters;
import com.mulesoft.connectors.inference.internal.connection.provider.ImageGenerationConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.openai.OpenAIImageGenerationConnection;
import com.mulesoft.connectors.inference.internal.llmmodels.openai.providers.OpenAIImageGenerationModelNameProvider;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="openai-image")
@DisplayName(value="OpenAI")
public class OpenAIImageGenerationConnectionProvider
extends ImageGenerationConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(OpenAIImageGenerationConnectionProvider.class);
    public static final String OPEN_AI_URL = "https://api.openai.com/v1";
    public static final String OPENAI_GENERATE_IMAGES = "/images/generations";
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=OpenAIImageGenerationModelNameProvider.class)
    @Placement(order=1)
    private String openAIModelName;
    @ParameterGroup(name="Connection")
    private BaseConnectionParameters baseConnectionParameters;

    public OpenAIImageGenerationConnection connect() {
        logger.debug("ImageGenerationConnection connect ...");
        return new OpenAIImageGenerationConnection(this.getHttpClient(), this.getObjectMapper(), this.openAIModelName, this.baseConnectionParameters.getApiKey(), this.baseConnectionParameters.getCustomHeaders(), this.baseConnectionParameters.getTimeout(), this.getImageGenerationAPIURL());
    }

    private String getImageGenerationAPIURL() {
        return "https://api.openai.com/v1/images/generations";
    }
}

