/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.provider.swisscom;

import com.mulesoft.connectors.inference.internal.connection.parameters.TextGenerationConnectionParameters;
import com.mulesoft.connectors.inference.internal.connection.provider.TextGenerationConnectionProvider;
import com.mulesoft.connectors.inference.internal.connection.types.swisscom.SwisscomTextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.llmmodels.swisscom.providers.SwisscomTextGenerationModelNameProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="swisscom")
@DisplayName(value="Swisscom")
public class SwisscomTextGenerationConnectionProvider
extends TextGenerationConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(SwisscomTextGenerationConnectionProvider.class);
    @Parameter
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=SwisscomTextGenerationModelNameProvider.class)
    @Optional(defaultValue="meta/llama-3.3-70b-instruct")
    private String swisscomModelName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="https://api.swisscom.com/layer/swiss-ai-platform/{modelName}/v1")
    @Placement(order=2)
    @DisplayName(value="[Swisscom] Base URL")
    private String swisscomURL;
    @ParameterGroup(name="Connection")
    private TextGenerationConnectionParameters swisscomTextGenerationConnectionParameters;

    public SwisscomTextGenerationConnection connect() throws ConnectionException {
        logger.debug("swisscomTextGenerationConnection connect ...");
        return new SwisscomTextGenerationConnection(this.getHttpClient(), this.getObjectMapper(), new ParametersDTO(this.swisscomModelName, this.swisscomTextGenerationConnectionParameters.getApiKey(), this.swisscomTextGenerationConnectionParameters.getMaxTokens(), this.swisscomTextGenerationConnectionParameters.getTemperature(), this.swisscomTextGenerationConnectionParameters.getTopP(), this.swisscomTextGenerationConnectionParameters.getTimeout(), this.swisscomTextGenerationConnectionParameters.getCustomHeaders()), this.swisscomURL);
    }
}

