/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.types.cohere;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.helpers.payload.CohereRequestPayloadHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.CohereHttpResponseHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.mapper.CohereResponseMapper;
import org.mule.runtime.http.api.client.HttpClient;

public class CohereTextGenerationConnection
extends TextGenerationConnection {
    private static final String URI_CHAT_COMPLETIONS = "/chat";
    public static final String COHERE_URL = "https://api.cohere.com/v2";
    private CohereResponseMapper responseMapper;
    private CohereRequestPayloadHelper requestPayloadHelper;
    private CohereHttpResponseHelper httpResponseHelper;

    public CohereTextGenerationConnection(HttpClient httpClient, ObjectMapper objectMapper, ParametersDTO parametersDTO) {
        super(httpClient, objectMapper, parametersDTO, CohereTextGenerationConnection.fetchApiURL());
    }

    @Override
    public CohereResponseMapper getResponseMapper() {
        if (this.responseMapper == null) {
            this.responseMapper = new CohereResponseMapper(this.getObjectMapper());
        }
        return this.responseMapper;
    }

    @Override
    public CohereRequestPayloadHelper getRequestPayloadHelper() {
        if (this.requestPayloadHelper == null) {
            this.requestPayloadHelper = new CohereRequestPayloadHelper(this.getObjectMapper());
        }
        return this.requestPayloadHelper;
    }

    @Override
    public CohereHttpResponseHelper getResponseHelper() {
        if (this.httpResponseHelper == null) {
            this.httpResponseHelper = new CohereHttpResponseHelper(this.getObjectMapper());
        }
        return this.httpResponseHelper;
    }

    private static String fetchApiURL() {
        return "https://api.cohere.com/v2/chat";
    }
}

