/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.connection.types.gemini;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.VisionModelConnection;
import com.mulesoft.connectors.inference.internal.dto.ParametersDTO;
import com.mulesoft.connectors.inference.internal.helpers.payload.GeminiRequestPayloadHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.GeminiHttpResponseHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.mapper.GeminiResponseMapper;
import java.util.Map;
import org.mule.runtime.http.api.client.HttpClient;

public class GeminiVisionConnection
extends VisionModelConnection {
    private static final String URI_CHAT_COMPLETIONS = "generateContent";
    public static final String GEMINI_URL = "https://generativelanguage.googleapis.com/v1beta/models/{model_id}:";
    private GeminiRequestPayloadHelper requestPayloadHelper;
    private GeminiResponseMapper responseMapper;
    private GeminiHttpResponseHelper httpResponseHelper;

    public GeminiVisionConnection(HttpClient httpClient, ObjectMapper objectMapper, ParametersDTO parametersDTO) {
        super(httpClient, objectMapper, parametersDTO, GeminiVisionConnection.fetchApiURL(parametersDTO.modelName()));
    }

    @Override
    public GeminiRequestPayloadHelper getRequestPayloadHelper() {
        if (this.requestPayloadHelper == null) {
            this.requestPayloadHelper = new GeminiRequestPayloadHelper(this.getObjectMapper());
        }
        return this.requestPayloadHelper;
    }

    @Override
    public GeminiResponseMapper getResponseMapper() {
        if (this.responseMapper == null) {
            this.responseMapper = new GeminiResponseMapper(this.getObjectMapper());
        }
        return this.responseMapper;
    }

    @Override
    public GeminiHttpResponseHelper getResponseHelper() {
        if (this.httpResponseHelper == null) {
            this.httpResponseHelper = new GeminiHttpResponseHelper(this.getObjectMapper());
        }
        return this.httpResponseHelper;
    }

    @Override
    public Map<String, String> getQueryParams() {
        return Map.of("key", this.getApiKey());
    }

    @Override
    public Map<String, String> getAdditionalHeaders() {
        return this.getCustomHeadersMap();
    }

    private static String fetchApiURL(String modelName) {
        String geminiUrlStr = "https://generativelanguage.googleapis.com/v1beta/models/{model_id}:generateContent";
        geminiUrlStr = geminiUrlStr.replace("{model_id}", modelName);
        return geminiUrlStr;
    }
}

