/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.helpers.payload;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.api.request.ChatPayloadRecord;
import com.mulesoft.connectors.inference.api.request.FunctionDefinitionRecord;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.connection.types.VisionModelConnection;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.DefaultRequestPayloadRecord;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.TextGenerationRequestPayloadDTO;
import com.mulesoft.connectors.inference.internal.dto.vision.DefaultVisionRequestPayloadRecord;
import com.mulesoft.connectors.inference.internal.dto.vision.VisionRequestPayloadDTO;
import com.mulesoft.connectors.inference.internal.dto.vision.gemini.FileData;
import com.mulesoft.connectors.inference.internal.dto.vision.gemini.InlineData;
import com.mulesoft.connectors.inference.internal.dto.vision.gemini.Part;
import com.mulesoft.connectors.inference.internal.dto.vision.gemini.VisionContentRecord;
import com.mulesoft.connectors.inference.internal.helpers.payload.GeminiRequestPayloadHelper;
import com.mulesoft.connectors.inference.internal.helpers.payload.RequestPayloadHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexAIRequestPayloadHelper
extends RequestPayloadHelper {
    private static final Logger logger = LoggerFactory.getLogger(VertexAIRequestPayloadHelper.class);
    public static final String GOOGLE_PROVIDER_TYPE = "Google";
    public static final String ANTHROPIC_PROVIDER_TYPE = "Anthropic";
    public static final String META_PROVIDER_TYPE = "Meta";
    public static final String VERTEX_AI_ANTHROPIC_VERSION_VALUE = "vertex-2023-10-16";
    private static final String DEFAULT_MIME_TYPE = "image/jpeg";
    private final GeminiRequestPayloadHelper geminiRequestPayloadHelper;

    public VertexAIRequestPayloadHelper(ObjectMapper objectMapper) {
        super(objectMapper);
        this.geminiRequestPayloadHelper = new GeminiRequestPayloadHelper(objectMapper);
    }

    @Override
    public TextGenerationRequestPayloadDTO buildChatAnswerPromptPayload(TextGenerationConnection connection, String prompt, Map<String, Object> additionalRequestAttributes) {
        String provider;
        return switch (provider = VertexAIRequestPayloadHelper.getProviderByModel(connection.getModelName())) {
            case GOOGLE_PROVIDER_TYPE -> this.geminiRequestPayloadHelper.buildChatAnswerPromptPayload(connection, prompt, additionalRequestAttributes);
            default -> this.getDefaultRequestPayloadDTO(connection, List.of(new ChatPayloadRecord("user", prompt)), additionalRequestAttributes);
        };
    }

    @Override
    public TextGenerationRequestPayloadDTO buildPromptTemplatePayload(TextGenerationConnection connection, String template, String instructions, String data, Map<String, Object> additionalRequestAttributes) {
        String provider;
        return switch (provider = VertexAIRequestPayloadHelper.getProviderByModel(connection.getModelName())) {
            case GOOGLE_PROVIDER_TYPE -> this.geminiRequestPayloadHelper.buildPromptTemplatePayload(connection, template, instructions, data, additionalRequestAttributes);
            default -> {
                List<ChatPayloadRecord> messagesArray = this.createMessagesArrayWithSystemPrompt(template + " - " + instructions, data);
                yield this.buildPayload(connection, messagesArray, null, additionalRequestAttributes);
            }
        };
    }

    @Override
    public TextGenerationRequestPayloadDTO parseAndBuildChatCompletionPayload(TextGenerationConnection connection, InputStream messages, Map<String, Object> additionalRequestAttributes) throws IOException {
        String provider;
        switch (provider = VertexAIRequestPayloadHelper.getProviderByModel(connection.getModelName())) {
            case "Google": {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Model not supported: " + connection.getModelName());
            }
        }
        return this.geminiRequestPayloadHelper.parseAndBuildChatCompletionPayload(connection, messages, additionalRequestAttributes);
    }

    @Override
    public TextGenerationRequestPayloadDTO buildToolsTemplatePayload(TextGenerationConnection connection, String template, String instructions, String data, List<FunctionDefinitionRecord> tools, Map<String, Object> additionalRequestAttributes) {
        throw new UnsupportedOperationException("Currently not supported");
    }

    @Override
    public TextGenerationRequestPayloadDTO buildToolsTemplatePayload(TextGenerationConnection connection, String template, String instructions, String data, InputStream tools, Map<String, Object> additionalRequestAttributes) throws IOException {
        String provider = VertexAIRequestPayloadHelper.getProviderByModel(connection.getModelName());
        throw new IllegalArgumentException(provider + ":" + connection.getModelName() + " on Vertex AI do not currently support function calling at this time.");
    }

    @Override
    public VisionRequestPayloadDTO createRequestImageURL(VisionModelConnection connection, String prompt, String imageUrl, Map<String, Object> additionalRequestAttributes) throws IOException {
        String provider;
        switch (provider = VertexAIRequestPayloadHelper.getProviderByModel(connection.getModelName())) {
            case "Google": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown provider");
            }
        }
        VisionContentRecord content = this.getGoogleVisionContentRecord(prompt, imageUrl);
        return this.buildVisionRequestPayload(connection, List.of(content), additionalRequestAttributes);
    }

    public static String getProviderByModel(String modelName) {
        logger.debug("model name {}", (Object)modelName);
        if (modelName == null || modelName.isEmpty()) {
            return "Unknown";
        }
        String upperName = modelName.toUpperCase();
        if (upperName.startsWith("GEMINI")) {
            return GOOGLE_PROVIDER_TYPE;
        }
        return "Unknown";
    }

    private VisionContentRecord getGoogleVisionContentRecord(String prompt, String imageUrl) throws IOException {
        ArrayList<Part> parts = new ArrayList<Part>();
        if (this.isBase64String(imageUrl)) {
            InlineData inlineData = new InlineData(this.getMimeType(imageUrl), imageUrl);
            parts.add(new Part(inlineData, null, null));
        } else {
            FileData fileData = new FileData(this.getMimeTypeFromUrl(imageUrl), imageUrl);
            parts.add(new Part(null, fileData, null));
        }
        parts.add(new Part(null, null, prompt));
        return new VisionContentRecord("user", parts);
    }

    private VisionRequestPayloadDTO buildVisionRequestPayload(VisionModelConnection connection, List<Object> messagesArray, Map<String, Object> additionalRequestAttributes) {
        String provider;
        return switch (provider = VertexAIRequestPayloadHelper.getProviderByModel(connection.getModelName())) {
            case GOOGLE_PROVIDER_TYPE -> this.geminiRequestPayloadHelper.buildVisionRequestPayload(connection, messagesArray, additionalRequestAttributes);
            default -> this.getDefaultVisionRequestPayloadDTO(connection, messagesArray, additionalRequestAttributes);
        };
    }

    private DefaultRequestPayloadRecord getDefaultRequestPayloadDTO(TextGenerationConnection connection, List<ChatPayloadRecord> chatPayloadRecordList, Map<String, Object> additionalRequestAttributes) {
        return new DefaultRequestPayloadRecord(connection.getModelName(), chatPayloadRecordList, connection.getMaxTokens(), connection.getTemperature(), connection.getTopP(), null, additionalRequestAttributes);
    }

    private DefaultVisionRequestPayloadRecord getDefaultVisionRequestPayloadDTO(VisionModelConnection connection, List<Object> chatPayloadRecordList, Map<String, Object> additionalRequestAttributes) {
        return new DefaultVisionRequestPayloadRecord(connection.getModelName(), chatPayloadRecordList, connection.getMaxTokens(), connection.getTemperature(), connection.getTopP(), additionalRequestAttributes);
    }

    private String getMimeTypeFromUrl(String imageUrl) {
        String extension;
        if (imageUrl == null || imageUrl.isBlank()) {
            return DEFAULT_MIME_TYPE;
        }
        String trimmedUrl = imageUrl.trim();
        int lastDotIndex = trimmedUrl.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return DEFAULT_MIME_TYPE;
        }
        return switch (extension = trimmedUrl.substring(lastDotIndex).toLowerCase()) {
            case ".png" -> "image/png";
            case ".pdf" -> "application/pdf";
            default -> DEFAULT_MIME_TYPE;
        };
    }
}

