/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.helpers.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.dto.imagegeneration.ImageGenerationRequestPayloadDTO;
import com.mulesoft.connectors.inference.internal.dto.imagegeneration.StabilityAIImageRequestPayloadRecord;
import com.mulesoft.connectors.inference.internal.dto.imagegeneration.response.ImageData;
import com.mulesoft.connectors.inference.internal.dto.imagegeneration.response.ImageGenerationRestResponse;
import com.mulesoft.connectors.inference.internal.error.InferenceErrorType;
import com.mulesoft.connectors.inference.internal.helpers.response.HttpResponseHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StabilityAIHttpResponseHelper
extends HttpResponseHelper {
    private static final Logger logger = LoggerFactory.getLogger(StabilityAIHttpResponseHelper.class);

    public StabilityAIHttpResponseHelper(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public ImageGenerationRestResponse processImageGenerationResponse(ImageGenerationRequestPayloadDTO requestPayloadDTO, HttpResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        String contentType = response.getHeaderValue("Content-Type");
        logger.debug("Processing StabilityAI image generation response. Response Code:{}", (Object)statusCode);
        if (statusCode == 200) {
            String responseBody = new String(response.getEntity().getBytes(), StandardCharsets.UTF_8);
            JSONObject stabilityResponse = new JSONObject(responseBody);
            if (StringUtils.isNotBlank((CharSequence)contentType) && contentType.contains("application/json") && stabilityResponse.has("image")) {
                String base64Image = stabilityResponse.getString("image");
                if (base64Image.startsWith("data:image")) {
                    base64Image = base64Image.substring(base64Image.indexOf(",") + 1);
                }
                logger.debug("Base64 image length for image generation response process: {}", (Object)base64Image.length());
                StabilityAIImageRequestPayloadRecord payloadRecord = (StabilityAIImageRequestPayloadRecord)requestPayloadDTO;
                return new ImageGenerationRestResponse(null, List.of(new ImageData(base64Image, payloadRecord.prompt())));
            }
            logger.error("Unexpected response format: Content-Type is {} and response body is {}", (Object)contentType, (Object)responseBody);
            throw new IOException("Unexpected response format from Stability AI API");
        }
        throw this.handleErrorResponse(response, statusCode, InferenceErrorType.IMAGE_GENERATION_FAILURE);
    }
}

