/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.helpers.response.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.api.metadata.AdditionalAttributes;
import com.mulesoft.connectors.inference.api.metadata.TokenUsage;
import com.mulesoft.connectors.inference.api.response.Function;
import com.mulesoft.connectors.inference.api.response.TextGenerationResponse;
import com.mulesoft.connectors.inference.api.response.ToolCall;
import com.mulesoft.connectors.inference.api.response.ToolResult;
import com.mulesoft.connectors.inference.internal.dto.mcp.McpToolRecord;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.TextResponseDTO;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.cohere.CohereChatCompletionResponse;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.cohere.CohereTokenUsage;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.cohere.Content;
import com.mulesoft.connectors.inference.internal.helpers.response.mapper.DefaultResponseMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CohereResponseMapper
extends DefaultResponseMapper {
    public CohereResponseMapper(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public TokenUsage mapTokenUsageFromResponse(TextResponseDTO responseDTO) {
        CohereChatCompletionResponse chatCompletionResponse = (CohereChatCompletionResponse)responseDTO;
        CohereTokenUsage chatRespUsage = chatCompletionResponse.usage();
        return new TokenUsage(chatRespUsage.billedUnits().inputTokens(), chatRespUsage.billedUnits().outputTokens(), chatRespUsage.billedUnits().inputTokens() + chatRespUsage.billedUnits().outputTokens());
    }

    @Override
    public AdditionalAttributes mapAdditionalAttributes(TextResponseDTO responseDTO, String modelName) {
        CohereChatCompletionResponse chatCompletionResponse = (CohereChatCompletionResponse)responseDTO;
        return new AdditionalAttributes(chatCompletionResponse.id(), modelName, chatCompletionResponse.finishReason(), null, null);
    }

    @Override
    public List<ToolCall> mapToolCalls(TextResponseDTO responseDTO, Map<String, McpToolRecord> collectedTools) {
        CohereChatCompletionResponse chatCompletionResponse = (CohereChatCompletionResponse)responseDTO;
        return this.convertToolCallsWithOriginalNames(chatCompletionResponse, collectedTools);
    }

    private List<ToolCall> convertToolCallsWithOriginalNames(CohereChatCompletionResponse chatResp, Map<String, McpToolRecord> collectedTools) {
        return Optional.ofNullable(chatResp.message().toolCalls()).stream().flatMap(Collection::stream).map(toolCall -> {
            McpToolRecord toolRecord = collectedTools != null ? (McpToolRecord)collectedTools.get(toolCall.function().name()) : null;
            String originalName = toolRecord != null ? toolRecord.originalName() : toolCall.function().name();
            return new ToolCall(toolCall.id(), toolCall.type(), new Function(originalName, toolCall.function().arguments()));
        }).toList();
    }

    @Override
    public TextGenerationResponse mapChatResponse(TextResponseDTO responseDTO) {
        CohereChatCompletionResponse chatCompletionResponse = (CohereChatCompletionResponse)responseDTO;
        Content chatRespFirstChoice = Optional.ofNullable(chatCompletionResponse.message()).flatMap(msg -> Optional.ofNullable(msg.content()).map(contents -> (Content)contents.get(0))).orElse(null);
        return new TextGenerationResponse(Optional.ofNullable(chatRespFirstChoice).map(Content::text).orElse(null), this.mapToolCalls(responseDTO, null), null);
    }

    @Override
    public TextGenerationResponse mapMcpExecuteToolsResponse(TextResponseDTO responseDTO, List<ToolResult> toolExecutionResult, Map<String, McpToolRecord> collectedTools) {
        CohereChatCompletionResponse chatCompletionResponse = (CohereChatCompletionResponse)responseDTO;
        Content chatRespFirstChoice = Optional.ofNullable(chatCompletionResponse.message()).flatMap(msg -> Optional.ofNullable(msg.content()).map(contents -> (Content)contents.get(0))).orElse(null);
        return new TextGenerationResponse(Optional.ofNullable(chatRespFirstChoice).map(Content::text).orElse(null), this.mapToolCalls(responseDTO, collectedTools), toolExecutionResult);
    }
}

