/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.helpers.response.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.api.metadata.AdditionalAttributes;
import com.mulesoft.connectors.inference.api.metadata.TokenUsage;
import com.mulesoft.connectors.inference.api.response.Function;
import com.mulesoft.connectors.inference.api.response.TextGenerationResponse;
import com.mulesoft.connectors.inference.api.response.ToolCall;
import com.mulesoft.connectors.inference.api.response.ToolResult;
import com.mulesoft.connectors.inference.internal.dto.mcp.McpToolRecord;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.gemini.PartRecord;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.TextResponseDTO;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.gemini.Candidate;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.gemini.GeminiChatCompletionResponse;
import com.mulesoft.connectors.inference.internal.dto.textgeneration.response.gemini.UsageMetadata;
import com.mulesoft.connectors.inference.internal.helpers.response.mapper.DefaultResponseMapper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiResponseMapper
extends DefaultResponseMapper {
    private static final Logger logger = LoggerFactory.getLogger(GeminiResponseMapper.class);

    public GeminiResponseMapper(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public TokenUsage mapTokenUsageFromResponse(TextResponseDTO responseDTO) {
        GeminiChatCompletionResponse chatCompletionResponse = (GeminiChatCompletionResponse)responseDTO;
        UsageMetadata chatRespUsage = chatCompletionResponse.usageMetadata();
        return new TokenUsage(chatRespUsage.promptTokenCount(), chatRespUsage.candidatesTokenCount(), chatRespUsage.totalTokenCount());
    }

    @Override
    public AdditionalAttributes mapAdditionalAttributes(TextResponseDTO responseDTO, String modelName) {
        logger.debug("Map Additional attributes for model:{}", (Object)modelName);
        GeminiChatCompletionResponse chatCompletionResponse = (GeminiChatCompletionResponse)responseDTO;
        Optional chatRespFirstChoice = chatCompletionResponse.candidates().stream().findFirst();
        return new AdditionalAttributes(chatCompletionResponse.responseId(), chatCompletionResponse.modelVersion(), chatRespFirstChoice.map(Candidate::finishReason).orElse("Unknown"), null, null);
    }

    @Override
    public List<ToolCall> mapToolCalls(TextResponseDTO responseDTO, Map<String, McpToolRecord> collectedTools) {
        GeminiChatCompletionResponse geminiResponse = (GeminiChatCompletionResponse)responseDTO;
        return geminiResponse.candidates().stream().filter(candidate -> candidate.content().parts() != null && !candidate.content().parts().isEmpty()).map(candidate -> candidate.content().parts().get(0).functionCall()).flatMap(fc -> Optional.ofNullable(fc).stream().map(functionCall -> new ToolCall(UUID.randomUUID().toString(), "function", new Function(this.convertToolCallsWithOriginalNames(functionCall.name(), collectedTools), this.convertToJsonString(functionCall.args()))))).toList();
    }

    @Override
    public TextGenerationResponse mapChatResponse(TextResponseDTO responseDTO) {
        GeminiChatCompletionResponse chatCompletionResponse = (GeminiChatCompletionResponse)responseDTO;
        Optional chatRespFirstChoice = chatCompletionResponse.candidates().stream().findFirst();
        return new TextGenerationResponse(chatRespFirstChoice.map(GeminiResponseMapper::mapTextResponse).orElse(null), this.mapToolCalls(responseDTO, null), null);
    }

    @Override
    public TextGenerationResponse mapMcpExecuteToolsResponse(TextResponseDTO responseDTO, List<ToolResult> toolExecutionResult, Map<String, McpToolRecord> collectedTools) {
        GeminiChatCompletionResponse chatCompletionResponse = (GeminiChatCompletionResponse)responseDTO;
        Optional chatRespFirstChoice = chatCompletionResponse.candidates().stream().findFirst();
        return new TextGenerationResponse(chatRespFirstChoice.map(GeminiResponseMapper::mapTextResponse).orElse(null), this.mapToolCalls(responseDTO, collectedTools), toolExecutionResult);
    }

    private static String mapTextResponse(Candidate x) {
        return Optional.ofNullable(x.content().parts()).flatMap(partRecords -> Optional.ofNullable((PartRecord)partRecords.get(0)).map(PartRecord::text)).orElse(null);
    }

    private String convertToJsonString(Map<String, Object> input) {
        try {
            return this.objectMapper.writeValueAsString(input);
        }
        catch (JsonProcessingException e) {
            logger.error("Error converting input to JSON string for tool call. Value for input field: {}", input, (Object)e);
            return null;
        }
    }

    private String convertToolCallsWithOriginalNames(String funcName, Map<String, McpToolRecord> collectedTools) {
        return Optional.ofNullable(collectedTools).map(toolMap -> Optional.ofNullable((McpToolRecord)collectedTools.get(funcName)).map(McpToolRecord::originalName).orElse(funcName)).orElse(funcName);
    }
}

