/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.operation;

import com.mulesoft.connectors.inference.internal.connection.types.ModerationConnection;
import com.mulesoft.connectors.inference.internal.error.InferenceErrorType;
import com.mulesoft.connectors.inference.internal.error.provider.ModerationErrorTypeProvider;
import java.io.InputStream;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Throws(value={ModerationErrorTypeProvider.class})
public class ModerationOperations {
    @MediaType(value="application/json", strict=false)
    @Alias(value="Toxicity-Detection-Text")
    @DisplayName(value="[Toxicity] Detection by Text")
    @OutputJsonType(schema="api/response/ResponseModeration.json")
    @Summary(value="Detects toxic input by text and classifies it into categories.")
    public Result<InputStream, Void> textModeration(@Connection ModerationConnection connection, @Content(primary=true) @Summary(value="Text to moderate. Can be a single string or an array of strings") InputStream text, @Content @Optional @DisplayName(value="Additional Request Attributes") @Summary(value="JSON object with additional request attributes that will be flattened into the root level of the request payload") InputStream additionalRequestAttributes) throws ModuleException {
        try {
            return connection.getService().getModerationServiceInstance().executeTextModeration(connection, text, additionalRequestAttributes);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException("Failed to process moderation request payload", (ErrorTypeDefinition)InferenceErrorType.TOXICITY_DETECTION_OPERATION_FAILURE, (Throwable)e);
        }
    }
}

