/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.operation;

import com.mulesoft.connectors.inference.api.mcp.McpConfig;
import com.mulesoft.connectors.inference.api.metadata.LLMResponseAttributes;
import com.mulesoft.connectors.inference.internal.config.TextGenerationConfig;
import com.mulesoft.connectors.inference.internal.connection.types.TextGenerationConnection;
import com.mulesoft.connectors.inference.internal.error.InferenceErrorType;
import com.mulesoft.connectors.inference.internal.error.provider.TextGenerationErrorTypeProvider;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CompletionException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.InputJsonType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Throws(value={TextGenerationErrorTypeProvider.class})
public class TextGenerationOperations {
    @MediaType(value="application/json", strict=false)
    @Alias(value="Chat-completions")
    @DisplayName(value="[Chat] Completions")
    @OutputJsonType(schema="api/response/Response.json")
    @Summary(value="Native chat completion operation")
    public Result<InputStream, LLMResponseAttributes> chatCompletion(@Connection TextGenerationConnection connection, @InputJsonType(schema="api/request/ChatCompletionMessagesSchema.json") @Content(primary=true) InputStream messages, @Content @Optional @DisplayName(value="Additional Request Attributes") @Summary(value="JSON object with additional request attributes that will be flattened into the root level of the request payload") InputStream additionalRequestAttributes) throws ModuleException {
        try {
            return connection.getService().getTextGenerationServiceInstance().executeChatCompletion(connection, messages, additionalRequestAttributes);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException("Error in executing chat completion", (ErrorTypeDefinition)InferenceErrorType.CHAT_OPERATION_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Chat-answer-prompt")
    @DisplayName(value="[Chat] Answer Prompt")
    @OutputJsonType(schema="api/response/Response.json")
    @Summary(value="Simple chat answer prompt")
    public Result<InputStream, LLMResponseAttributes> chatAnswerPrompt(@Connection TextGenerationConnection connection, @Content(primary=true) String prompt, @Content @Optional @DisplayName(value="Additional Request Attributes") @Summary(value="JSON object with additional request attributes that will be flattened into the root level of the request payload") InputStream chatRequestAttributes) throws ModuleException {
        try {
            return connection.getService().getTextGenerationServiceInstance().executeChatAnswerPrompt(connection, prompt, chatRequestAttributes);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException("Error in executing chat answer prompt", (ErrorTypeDefinition)InferenceErrorType.CHAT_OPERATION_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Agent-define-prompt-template")
    @DisplayName(value="[Agent] Define Prompt Template")
    @OutputJsonType(schema="api/response/Response.json")
    @Summary(value="Define a prompt template with instructions, and data ")
    public Result<InputStream, LLMResponseAttributes> promptTemplate(@Connection TextGenerationConnection connection, @Content String template, @Content String instructions, @Content(primary=true) String data, @Content @Optional @DisplayName(value="Additional Request Attributes") @Summary(value="JSON object with additional request attributes that will be flattened into the root level of the request payload") InputStream promptRequestAttributes) throws ModuleException {
        try {
            return connection.getService().getTextGenerationServiceInstance().definePromptTemplate(connection, template, instructions, data, promptRequestAttributes);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException("Error in executing define prompt template", (ErrorTypeDefinition)InferenceErrorType.CHAT_OPERATION_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Tools-native-template")
    @DisplayName(value="[Tools] Native Template (Reasoning only)")
    @OutputJsonType(schema="api/response/Response.json")
    @Summary(value="[Tools] Native Template (Reasoning only)")
    public Result<InputStream, LLMResponseAttributes> toolsTemplate(@Connection TextGenerationConnection connection, @Content String template, @Content String instructions, @Content(primary=true) String data, @Content @InputJsonType(schema="api/request/ToolsDefinition.json") @Summary(value="JSON Array defining the tools set to be used in the template so that the LLM can use them if required") InputStream tools, @Content @Optional @DisplayName(value="Additional Request Attributes") @Summary(value="JSON object with additional request attributes that will be flattened into the root level of the request payload") InputStream toolsRequestAttributes) throws ModuleException {
        try {
            return connection.getService().getTextGenerationServiceInstance().executeToolsNativeTemplate(connection, template, instructions, data, tools, toolsRequestAttributes);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException("Error in executing operation Tools native template", (ErrorTypeDefinition)InferenceErrorType.TOOLS_OPERATION_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Mcp-tools-native-template")
    @DisplayName(value="[MCP] Tooling")
    @OutputJsonType(schema="api/response/McpToolingResponse.json")
    @Summary(value="Run tools using your defined prompt template")
    public Result<InputStream, LLMResponseAttributes> mcpToolsTemplate(@Config TextGenerationConfig config, @Connection TextGenerationConnection connection, @ParameterDsl(allowReferences=false) List<McpConfig> mcpConfigReferences, @Content String template, @Content String instructions, @Content(primary=true) String data, @Content @Optional @DisplayName(value="Additional Request Attributes") @Summary(value="JSON object with additional request attributes that will be flattened into the root level of the request payload") InputStream mcpRequestAttributes, ExtensionsClient extensionsClient) throws ModuleException {
        Scheduler scheduler = null;
        try {
            scheduler = config.getSchedulerService().ioScheduler(config.getSchedulerConfig().withName("mcp-discovery-scheduler"));
            Result<InputStream, LLMResponseAttributes> result = connection.getService().getTextGenerationServiceInstance().executeMcpTools(connection, scheduler, extensionsClient, mcpConfigReferences, template, instructions, data, mcpRequestAttributes);
            return result;
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ModuleException) {
                ModuleException moduleException = (ModuleException)cause;
                throw moduleException;
            }
            throw new ModuleException("Error in executing operation MCP tooling", (ErrorTypeDefinition)InferenceErrorType.MCP_TOOLS_OPERATION_FAILURE, cause != null ? cause : e);
        }
        catch (Exception e) {
            throw new ModuleException("Error in executing operation MCP tooling", (ErrorTypeDefinition)InferenceErrorType.MCP_TOOLS_OPERATION_FAILURE, (Throwable)e);
        }
        finally {
            if (scheduler != null) {
                scheduler.stop();
            }
        }
    }
}

