/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.inference.internal.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.inference.internal.connection.types.ModerationConnection;
import com.mulesoft.connectors.inference.internal.dto.moderation.ModerationRequestPayloadRecord;
import com.mulesoft.connectors.inference.internal.dto.moderation.response.ModerationRestResponse;
import com.mulesoft.connectors.inference.internal.helpers.ResponseHelper;
import com.mulesoft.connectors.inference.internal.helpers.payload.RequestPayloadHelper;
import com.mulesoft.connectors.inference.internal.helpers.request.HttpRequestHelper;
import com.mulesoft.connectors.inference.internal.helpers.response.HttpResponseHelper;
import com.mulesoft.connectors.inference.internal.service.BaseService;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModerationService
implements BaseService {
    private static final Logger logger = LoggerFactory.getLogger(ModerationService.class);
    private final RequestPayloadHelper payloadHelper;
    private final HttpRequestHelper httpRequestHelper;
    private final HttpResponseHelper responseHelper;
    private final ObjectMapper objectMapper;

    public ModerationService(RequestPayloadHelper requestPayloadHelper, HttpRequestHelper httpRequestHelper, HttpResponseHelper responseHelper, ObjectMapper objectMapper) {
        this.payloadHelper = requestPayloadHelper;
        this.httpRequestHelper = httpRequestHelper;
        this.responseHelper = responseHelper;
        this.objectMapper = objectMapper;
    }

    public Result<InputStream, Void> executeTextModeration(ModerationConnection connection, InputStream text, InputStream additionalRequestAttributes) throws IOException, TimeoutException {
        ModerationRequestPayloadRecord payload = this.payloadHelper.getModerationRequestPayload(connection.getModelName(), text, additionalRequestAttributes);
        logger.debug("Moderation payload that will be sent to the LLM {}", (Object)payload);
        HttpResponse response = this.httpRequestHelper.executeModerationRestRequest(connection, connection.getApiURL(), payload);
        logger.debug("Moderation service - response from LLM: {}", (Object)response);
        ModerationRestResponse moderationRestResponse = this.responseHelper.processModerationResponse(response);
        return ResponseHelper.createLLMResponse(this.objectMapper.writeValueAsString((Object)this.responseHelper.mapModerationFinalResponse(moderationRestResponse)));
    }
}

