/*
 * Decompiled with CFR 0.152.
 */
package com.mule.mulechain.crawler.internal;

import com.mule.mulechain.crawler.internal.MulechainwebcrawlerConfiguration;
import com.mule.mulechain.crawler.internal.helpers.CrawlResult;
import com.mule.mulechain.crawler.internal.helpers.SiteMapNode;
import com.mule.mulechain.crawler.internal.helpers.crawlingHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.jsoup.UnsupportedMimeTypeException;
import org.jsoup.nodes.Document;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulechainwebcrawlerOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(MulechainwebcrawlerOperations.class);

    @MediaType(value="application/json", strict=false)
    @Alias(value="Crawl-website")
    public InputStream crawlWebsite(@Config MulechainwebcrawlerConfiguration configuration, @DisplayName(value="Website URL") @Placement(order=1) @Example(value="https://mac-project.ai/docs") String url, @DisplayName(value="Restrict Crawl under URL") @Placement(order=2) @Example(value="False") boolean restrictToPath, @DisplayName(value="Dynamic Content Retrieval") @Placement(order=3) @Example(value="False") boolean dynamicContent, @DisplayName(value="Maximum Depth") @Placement(order=4) @Example(value="2") int maxDepth, @DisplayName(value="Delay (millisecs)") @Placement(order=5) @Example(value="0") int delayMillis, @DisplayName(value="Retrieve Meta Tags") @Placement(order=6) @Example(value="False") boolean getMetaTags, @DisplayName(value="Download Images") @Placement(order=7) @Example(value="False") boolean downloadImages, @DisplayName(value="Download Location") @Placement(order=8) @Example(value="/users/mulesoft/downloads") String downloadPath) throws IOException {
        LOGGER.info("Website crawl action");
        HashSet<String> visitedLinksGlobal = new HashSet<String>();
        HashMap<Integer, Set<String>> visitedLinksByDepth = new HashMap<Integer, Set<String>>();
        List<String> specificTags = configuration.getTags();
        String originalUrl = url;
        SiteMapNode root = this.startCrawling(url, originalUrl, 0, maxDepth, restrictToPath, dynamicContent, delayMillis, visitedLinksByDepth, visitedLinksGlobal, downloadImages, downloadPath, specificTags, getMetaTags, CrawlType.CONTENT);
        return IOUtils.toInputStream((String)crawlingHelper.convertToJSON(root), (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Get-page-meta-tags")
    public InputStream getMetaTags(@DisplayName(value="Page URL") @Placement(order=1) @Example(value="https://mac-project.ai/docs") String url) throws IOException {
        LOGGER.info("Get meta tags");
        Document document = crawlingHelper.getDocument(url);
        return IOUtils.toInputStream((String)crawlingHelper.convertToJSON(crawlingHelper.getPageMetaTags(document)), (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Generate-sitemap")
    public InputStream getSiteMap(@DisplayName(value="Website URL") @Placement(order=1) @Example(value="https://mac-project.ai/docs") String url, @DisplayName(value="Maximum Depth") @Placement(order=2) @Example(value="2") int maxDepth, @DisplayName(value="Delay (millisecs)") @Placement(order=3) @Example(value="0") int delayMillis) throws IOException {
        LOGGER.info("Generate sitemap");
        HashSet<String> visitedLinksGlobal = new HashSet<String>();
        HashMap<Integer, Set<String>> visitedLinksByDepth = new HashMap<Integer, Set<String>>();
        String originalUrl = url;
        SiteMapNode root = this.startCrawling(url, originalUrl, 0, maxDepth, false, false, delayMillis, visitedLinksByDepth, visitedLinksGlobal, false, null, null, false, CrawlType.LINK);
        return IOUtils.toInputStream((String)crawlingHelper.convertToJSON(root), (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Download-image")
    public InputStream downloadWebsiteImages(@DisplayName(value="Page Or Image URL") @Placement(order=1) @Example(value="https://mac-project.ai/docs") String url, @DisplayName(value="Download Location") @Placement(order=2) @Example(value="/users/mulesoft/downloads") String downloadPath) throws IOException {
        String result = "";
        try {
            Document document = crawlingHelper.getDocument(url);
            result = crawlingHelper.convertToJSON(this.downloadWebsiteImages(document, downloadPath));
        }
        catch (UnsupportedMimeTypeException e) {
            HashMap<String, String> linkFileMap = new HashMap<String, String>();
            linkFileMap.put(url, this.downloadSingleImage(url, downloadPath));
            result = crawlingHelper.convertToJSON(linkFileMap);
        }
        return IOUtils.toInputStream((String)result, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Get-page-insights")
    public InputStream getPageInsights(@Config MulechainwebcrawlerConfiguration configuration, @DisplayName(value="Page Url") @Placement(order=1) @Example(value="https://mac-project.ai/docs") String url) throws IOException {
        LOGGER.info("Analyze page");
        Document document = crawlingHelper.getDocument(url);
        return IOUtils.toInputStream((String)crawlingHelper.convertToJSON(crawlingHelper.getPageInsights(document, configuration.getTags(), crawlingHelper.PageInsightType.ALL)), (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Get-page-content")
    public InputStream getPageContent(@Config MulechainwebcrawlerConfiguration configuration, @DisplayName(value="Page Url") @Placement(order=1) @Example(value="https://mac-project.ai/docs") String url) throws IOException {
        LOGGER.info("Get page content");
        HashMap<String, String> contents = new HashMap<String, String>();
        Document document = crawlingHelper.getDocument(url);
        contents.put("url", document.baseUri());
        contents.put("title", document.title());
        contents.put("content", crawlingHelper.getPageContent(document, configuration.getTags()));
        return IOUtils.toInputStream((String)crawlingHelper.convertToJSON(contents), (Charset)StandardCharsets.UTF_8);
    }

    private String savePageContents(Object results, String downloadPath, String title) throws IOException {
        String pageContents = crawlingHelper.convertToJSON(results);
        String fileName = "";
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        fileName = crawlingHelper.getSanitizedFilename(title) + "_" + timestamp + ".json";
        File file = new File(downloadPath, fileName);
        file.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(pageContents);
            LOGGER.info("Saved content to file: " + fileName);
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while writing to the file: " + e.getMessage());
        }
        return file != null ? file.getName() : "File is null";
    }

    private SiteMapNode startCrawling(String url, String originalUrl, int depth, int maxDepth, boolean restrictToPath, boolean dynamicContent, int delayMillis, Map<Integer, Set<String>> visitedLinksByDepth, Set<String> visitedLinksGlobal, boolean downloadImages, String downloadPath, List<String> contentTags, boolean getMetaTags, CrawlType crawlType) {
        if (depth > maxDepth) {
            return null;
        }
        if (restrictToPath && !url.startsWith(originalUrl)) {
            LOGGER.info("SKIPPING due to strict crawling: " + url);
            return null;
        }
        visitedLinksByDepth.putIfAbsent(depth, new HashSet());
        if (visitedLinksByDepth.get(depth).contains(url)) {
            return null;
        }
        try {
            crawlingHelper.addDelay(delayMillis);
            visitedLinksByDepth.get(depth).add(url);
            SiteMapNode node = null;
            Document document = null;
            document = dynamicContent ? crawlingHelper.getDocumentDynamic(url) : crawlingHelper.getDocument(url);
            if (!visitedLinksGlobal.contains(url) && crawlType == CrawlType.CONTENT) {
                visitedLinksGlobal.add(url);
                HashMap<String, Object> pageData = new HashMap<String, Object>();
                LOGGER.info("Fetching content for : " + url);
                String title = document.title();
                pageData.put("url", url);
                pageData.put("title", title);
                if (downloadImages) {
                    LOGGER.info("Downloading images for : " + url);
                    pageData.put("imageFiles", this.downloadWebsiteImages(document, downloadPath));
                }
                if (getMetaTags) {
                    for (Map.Entry entry : crawlingHelper.getPageMetaTags(document).entrySet()) {
                        pageData.put((String)entry.getKey(), entry.getValue());
                    }
                }
                pageData.put("content", crawlingHelper.getPageContent(document, contentTags));
                String filename = this.savePageContents(pageData, downloadPath, title);
                node = new CrawlResult(url, filename);
            } else if (crawlType == CrawlType.LINK) {
                node = new SiteMapNode(url);
                LOGGER.info("Found url : " + url);
            } else {
                node = new CrawlResult(url, "Duplicate.");
            }
            if (depth <= maxDepth) {
                Set links = new HashSet();
                Map linksMap = (Map)crawlingHelper.getPageInsights(document, null, crawlingHelper.PageInsightType.INTERNALLINKS).get("links");
                if (linksMap != null) {
                    links = (Set)linksMap.get("internal");
                }
                if (links != null) {
                    for (String string : links) {
                        SiteMapNode childNode = this.startCrawling(string, originalUrl, depth + 1, maxDepth, restrictToPath, dynamicContent, delayMillis, visitedLinksByDepth, visitedLinksGlobal, downloadImages, downloadPath, contentTags, getMetaTags, crawlType);
                        if (childNode == null) continue;
                        node.addChild(childNode);
                    }
                }
            }
            return node;
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            return null;
        }
    }

    private Map<String, String> downloadWebsiteImages(Document document, String saveDirectory) throws IOException {
        Set imageUrls = new HashSet();
        HashMap<String, String> linkFileMap = new HashMap<String, String>();
        Map linksMap = (Map)crawlingHelper.getPageInsights(document, null, crawlingHelper.PageInsightType.IMAGELINKS).get("links");
        if (linksMap != null) {
            imageUrls = (Set)linksMap.get("images");
        }
        if (imageUrls != null) {
            LOGGER.info("Number of img[src] elements found : " + imageUrls.size());
            for (String imageUrl : imageUrls) {
                linkFileMap.put(imageUrl, this.downloadSingleImage(imageUrl, saveDirectory));
            }
        }
        return linkFileMap;
    }

    private String downloadSingleImage(String imageUrl, String saveDirectory) throws IOException {
        File file;
        block24: {
            LOGGER.info("Found image : " + imageUrl);
            try {
                if (imageUrl.startsWith("data:image/")) {
                    byte[] imageBytes;
                    String base64Data = imageUrl.substring(imageUrl.indexOf(",") + 1);
                    if (base64Data.isEmpty()) {
                        LOGGER.info("Base64 data is empty for URL: " + imageUrl);
                        return "";
                    }
                    try {
                        imageBytes = Base64.getDecoder().decode(base64Data);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.info("Error decoding base64 data: " + e.getMessage());
                        return "";
                    }
                    if (imageBytes.length == 0) {
                        LOGGER.info("Decoded image bytes are empty for URL: " + imageUrl);
                        return "";
                    }
                    String fileType = imageUrl.substring(5, imageUrl.indexOf(";"));
                    String fileExtension = fileType.split("/")[1];
                    String timestamp = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
                    String fileName = "image_" + timestamp + "." + fileExtension;
                    file = new File(saveDirectory, fileName);
                    file.getParentFile().mkdirs();
                    try (FileOutputStream out = new FileOutputStream(file);){
                        out.write(imageBytes);
                        LOGGER.info("DataImage saved: " + file.getAbsolutePath());
                        break block24;
                    }
                }
                URL url = new URL(imageUrl);
                String decodedUrl = crawlingHelper.extractAndDecodeUrl(imageUrl);
                String fileName = crawlingHelper.extractFileNameFromUrl(decodedUrl);
                file = new File(saveDirectory, fileName);
                file.getParentFile().mkdirs();
                try (InputStream in = url.openStream();
                     FileOutputStream out = new FileOutputStream(file);){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                }
                LOGGER.info("Image saved: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                LOGGER.error("Error saving image: " + imageUrl);
                throw e;
            }
        }
        return file != null ? file.getName() : "File is null";
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Google-search")
    public String googleSearch(@DisplayName(value="Search Query") @Placement(order=1) @Example(value="apple inc") String query, @DisplayName(value="API Key") @Placement(order=2) @Example(value="your_api_key_here") String apiKey) throws IOException {
        LOGGER.info("Performing Google search for query: " + query);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        okhttp3.MediaType mediaType = okhttp3.MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((String)("{\"q\":\"" + query + "\"}"), (okhttp3.MediaType)mediaType);
        Request request = new Request.Builder().url("https://google.serper.dev/search").method("POST", body).addHeader("X-API-KEY", apiKey).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new IOException("Unexpected code " + response);
        }
        String responseBody = response.body().string();
        JSONObject jsonResponse = new JSONObject(responseBody);
        return jsonResponse.toString(4);
    }

    private static enum CrawlType {
        CONTENT,
        LINK;

    }
}

