/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.crawler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.extension.webcrawler.internal.crawler.mule.MuleCrawler;
import org.mule.extension.webcrawler.internal.error.WebCrawlerErrorType;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Crawler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Crawler.class);
    protected Set<String> visitedLinksGlobal;
    protected Map<Integer, Set<String>> visitedLinksByDepth;
    protected String userAgent;
    protected String rootReferrer;
    protected String rootURL;
    protected int maxDepth;
    protected boolean restrictToPath;
    protected boolean dynamicContent;
    protected int delayMillis;
    protected boolean downloadImages;
    protected int maxImageNumber;
    protected boolean downloadDocuments;
    protected int maxDocumentNumber;
    protected String downloadPath;
    protected List<String> contentTags;
    protected boolean rawHtml;
    protected boolean getMetaTags;

    public Crawler(String userAgent, String rootReferrer, String rootURL, int maxDepth, boolean restrictToPath, boolean dynamicContent, int delayMillis, boolean downloadImages, int maxImageNumber, boolean downloadDocuments, int maxDocumentNumber, String downloadPath, List<String> contentTags, boolean rawHtml, boolean getMetaTags) {
        this.userAgent = userAgent;
        this.rootReferrer = rootReferrer;
        this.rootURL = rootURL;
        this.maxDepth = maxDepth;
        this.restrictToPath = restrictToPath;
        this.dynamicContent = dynamicContent;
        this.delayMillis = delayMillis;
        this.downloadImages = downloadImages;
        this.maxImageNumber = maxImageNumber;
        this.downloadDocuments = downloadDocuments;
        this.maxDocumentNumber = maxDocumentNumber;
        this.downloadPath = downloadPath;
        this.contentTags = contentTags;
        this.rawHtml = rawHtml;
        this.getMetaTags = getMetaTags;
    }

    public abstract CrawlNode crawl();

    public abstract MapNode map();

    public static Builder builder() {
        return new Builder();
    }

    public static class CrawlNode
    extends MapNode {
        private final String pageContentFile;

        public CrawlNode(String pageURL, String pageContentFile) {
            super(pageURL);
            this.pageContentFile = pageContentFile;
        }

        public String getPageContentFile() {
            return this.pageContentFile;
        }
    }

    public static class MapNode {
        private String url;
        private List<MapNode> children;

        public MapNode(String url) {
            this.url = url;
            this.children = new ArrayList<MapNode>();
        }

        public String getUrl() {
            return this.url;
        }

        public List<MapNode> getChildren() {
            return this.children;
        }

        public void addChild(MapNode child) {
            this.children.add(child);
        }
    }

    public static class Builder {
        private String userAgent;
        private String rootReferrer;
        private String rootURL;
        private int maxDepth;
        private boolean restrictToPath = false;
        private boolean dynamicContent = false;
        private int delayMillis;
        private boolean downloadImages;
        private int maxImageNumber;
        private boolean downloadDocuments;
        private int maxDocumentNumber;
        private String downloadPath;
        private List<String> contentTags;
        private boolean rawHtml = false;
        private boolean getMetaTags = false;

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder rootReferrer(String rootReferrer) {
            this.rootReferrer = rootReferrer;
            return this;
        }

        public Builder rootURL(String rootURL) {
            this.rootURL = rootURL;
            return this;
        }

        public Builder maxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public Builder restrictToPath(boolean restrictToPath) {
            this.restrictToPath = restrictToPath;
            return this;
        }

        public Builder dynamicContent(boolean dynamicContent) {
            this.dynamicContent = dynamicContent;
            return this;
        }

        public Builder delayMillis(int delayMillis) {
            this.delayMillis = delayMillis;
            return this;
        }

        public Builder downloadImages(boolean downloadImages) {
            this.downloadImages = downloadImages;
            return this;
        }

        public Builder maxImageNumber(int maxImageNumber) {
            this.maxImageNumber = maxImageNumber;
            return this;
        }

        public Builder downloadDocuments(boolean downloadDocuments) {
            this.downloadDocuments = downloadDocuments;
            return this;
        }

        public Builder maxDocumentNumber(int maxDocumentNumber) {
            this.maxDocumentNumber = maxDocumentNumber;
            return this;
        }

        public Builder downloadPath(String downloadPath) {
            this.downloadPath = downloadPath;
            return this;
        }

        public Builder contentTags(List<String> contentTags) {
            this.contentTags = contentTags;
            return this;
        }

        public Builder rawHtml(boolean rawHtml) {
            this.rawHtml = rawHtml;
            return this;
        }

        public Builder getMetaTags(boolean getMetaTags) {
            this.getMetaTags = getMetaTags;
            return this;
        }

        public Crawler build() {
            MuleCrawler crawler;
            try {
                crawler = new MuleCrawler(this.userAgent, this.rootReferrer, this.rootURL, this.maxDepth, this.restrictToPath, this.dynamicContent, this.delayMillis, this.downloadImages, this.maxImageNumber, this.downloadDocuments, this.maxDocumentNumber, this.downloadPath, this.contentTags, this.rawHtml, this.getMetaTags);
            }
            catch (ModuleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModuleException("Error while initializing crawler.", (ErrorTypeDefinition)WebCrawlerErrorType.CRAWL_OPERATIONS_FAILURE, (Throwable)e);
            }
            return crawler;
        }
    }
}

