/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.helper.webdriver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.mule.extension.webcrawler.internal.helper.webdriver.CloudHubRpmExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudHubChromeConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudHubChromeConfigurer.class);
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    public static final String LATEST_MILESTONE_VERSION_URL = "https://googlechromelabs.github.io/chrome-for-testing/latest-versions-per-milestone.json";
    public static final String CHROME_CDP_VERSION = "133";
    public static final String CHROME_DEPENDENCY_RESOURCE_PATH = "/cloudhub-chrome-dependencies.zip";
    public static final String CHROME_DEPENDENCY_LIBS_PATH = "/tmp/chrome-deps-linux64";
    public static final String CHROME_DEPENDENCY_RPM_PATH = "/tmp/rpms-linux64";
    public static final String CHROME_PATH = "/tmp/chrome-linux64";
    public static final String CHROME_WRAPPER_SCRIPT_CONTENT = "#!/bin/bash\nexport LD_LIBRARY_PATH=/tmp/chrome-deps-linux64:$LD_LIBRARY_PATH\nexec /tmp/chrome-linux64/chrome \"$@\"\n";
    public static final String CHROME_WEBDRIVER_PATH = "/tmp/chromedriver-linux64";
    public static String CHROME_WEBDRIVER_WRAPPER_SCRIPT_CONTENT = "#!/bin/bash\nexport LD_LIBRARY_PATH=/tmp/chrome-deps-linux64:$LD_LIBRARY_PATH\nexec /tmp/chromedriver-linux64/chromedriver \"$@\"\n";
    public static final String CHROME_LIB_WRAPPER_SCRIPT = "/tmp/chrome-linux64/chrome-lib-wrapper";
    public static final String CHROME_WEBDRIVER_WRAPPER_SCRIPT = "/tmp/chrome-linux64/chrome-webdriver-wrapper";

    public static boolean isCloudHubDeployment() {
        return Boolean.getBoolean("cloudhub.deployment");
    }

    public static void setup() {
        if (initialized.compareAndSet(false, true)) {
            LOGGER.debug("Executing Chrome setup");
            try {
                JSONObject jsonResponse = new JSONObject(CloudHubChromeConfigurer.getChromeMilestoneVersionJsonAsString());
                String chromeVersion = jsonResponse.getJSONObject("milestones").getJSONObject(CHROME_CDP_VERSION).getString("version");
                String chromeDownloadUrl = String.format("https://storage.googleapis.com/chrome-for-testing-public/%s/linux64/chrome-linux64.zip", chromeVersion);
                String chromeDriverDownloadUrl = String.format("https://storage.googleapis.com/chrome-for-testing-public/%s/linux64/chromedriver-linux64.zip", chromeVersion);
                LOGGER.info("Downloading Chrome from: {}", (Object)chromeDownloadUrl);
                FileUtils.copyURLToFile((URL)new URL(chromeDownloadUrl), (File)new File("/tmp/chrome-linux64.zip"));
                LOGGER.info("Downloading ChromeDriver from: {}", (Object)chromeDriverDownloadUrl);
                FileUtils.copyURLToFile((URL)new URL(chromeDriverDownloadUrl), (File)new File("/tmp/chromedriver-linux64.zip"));
                CloudHubChromeConfigurer.unzip("/tmp/chrome-linux64.zip", "/tmp");
                CloudHubChromeConfigurer.unzip("/tmp/chromedriver-linux64.zip", "/tmp");
                CloudHubChromeConfigurer.createLibWrapperScript(CHROME_LIB_WRAPPER_SCRIPT, CHROME_WRAPPER_SCRIPT_CONTENT);
                CloudHubChromeConfigurer.createLibWrapperScript(CHROME_WEBDRIVER_WRAPPER_SCRIPT, CHROME_WEBDRIVER_WRAPPER_SCRIPT_CONTENT);
                CloudHubRpmExtractor.extractRpmsFromJar();
                System.setProperty("webdriver.chrome.driver", CHROME_WEBDRIVER_WRAPPER_SCRIPT);
                CloudHubChromeConfigurer.logChromeVersion();
            }
            catch (Exception e) {
                LOGGER.error("Error in Chrome setup", (Throwable)e);
            }
        }
    }

    private static String getChromeMilestoneVersionJsonAsString() {
        try {
            String line;
            URL url = new URL(LATEST_MILESTONE_VERSION_URL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = in.readLine()) != null) {
                response.append(line);
            }
            in.close();
            return response.toString();
        }
        catch (Exception e) {
            LOGGER.error("Error fetching latest Chrome milestone version JSON", (Object)e.getMessage());
            return null;
        }
    }

    private static void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                CloudHubChromeConfigurer.extractEntry(zipFile, entry, destDir);
            }
        }
    }

    private static void extractEntry(ZipFile zipFile, ZipArchiveEntry entry, File destDir) throws IOException {
        File outputFile = new File(destDir, entry.getName());
        if (entry.isDirectory()) {
            outputFile.mkdirs();
        } else {
            outputFile.getParentFile().mkdirs();
            Files.copy(zipFile.getInputStream(entry), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if ((entry.getUnixMode() & 0x40) != 0) {
                outputFile.setExecutable(true);
            }
        }
    }

    public static void logFilesWithProperties(String directoryPath) {
        File directory = new File(directoryPath);
        if (!directory.exists() || !directory.isDirectory()) {
            LOGGER.info("Invalid directory path: {}", (Object)directoryPath);
            return;
        }
        File[] files = directory.listFiles();
        if (files == null || files.length == 0) {
            LOGGER.info("No files found in the directory: {}", (Object)directoryPath);
            return;
        }
        for (File file : files) {
            CloudHubChromeConfigurer.logFileProperties(file);
        }
    }

    public static void logFileProperties(File file) {
        try {
            Path filePath = file.toPath();
            boolean isExecutable = Files.isExecutable(filePath);
            boolean isReadable = Files.isReadable(filePath);
            boolean isWritable = Files.isWritable(filePath);
            long fileSize = Files.size(filePath);
            LOGGER.info("{} | Executable: {} | Readable: {} | Writable: {} | Size: {} bytes", new Object[]{file.getAbsolutePath(), isExecutable, isReadable, isWritable, fileSize});
        }
        catch (Exception e) {
            LOGGER.info("Error reading properties for file: {}", (Object)file.getAbsolutePath());
        }
    }

    public static void logChromeVersion() throws IOException, InterruptedException {
        try {
            Process process = new ProcessBuilder(CHROME_LIB_WRAPPER_SCRIPT, "--version").start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String version = reader.readLine();
            LOGGER.info("Chrome version is: {}", (Object)version);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get Chrome version", (Object)e.getMessage());
            LOGGER.info("Dumping diagnostic logs");
            CloudHubChromeConfigurer.logLddOutput();
            CloudHubChromeConfigurer.logFilesWithProperties(CHROME_PATH);
            CloudHubChromeConfigurer.logFilesWithProperties(CHROME_WEBDRIVER_PATH);
            CloudHubChromeConfigurer.logFilesWithProperties(CHROME_DEPENDENCY_LIBS_PATH);
        }
    }

    public static void createLibWrapperScript(String path, String content) {
        try {
            File scriptFile = new File(path);
            scriptFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(scriptFile);){
                writer.write(content);
            }
            scriptFile.setExecutable(true);
            LOGGER.info("Wrapper script created at: {}", (Object)path);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create wrapper script", (Object)e.getMessage());
        }
    }

    public static void logLddOutput() throws IOException, InterruptedException {
        String[] command = new String[]{"/bin/bash", "-c", "export LD_LIBRARY_PATH=/tmp/chrome-deps-linux64 && ldd /tmp/chrome-linux64/chrome"};
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        LOGGER.info("ldd diagnostic logs");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                LOGGER.info(line);
            }
        }
        int exitCode = process.waitFor();
        if (exitCode == 0) {
            LOGGER.info("ldd completed successfully.");
        } else {
            LOGGER.error("ldd failed with exit code: {}", (Object)exitCode);
        }
    }
}

