/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.helper.webdriver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudHubRpmExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudHubRpmExtractor.class);

    public static void extractRpmsFromJar() throws IOException {
        LOGGER.info("Extracting RPMs from /cloudhub-chrome-dependencies.zip");
        Files.createDirectories(Paths.get("/tmp/rpms-linux64", new String[0]), new FileAttribute[0]);
        Files.createDirectories(Paths.get("/tmp/chrome-deps-linux64", new String[0]), new FileAttribute[0]);
        try (InputStream zipStream = CloudHubRpmExtractor.class.getResourceAsStream("/cloudhub-chrome-dependencies.zip");
             ZipInputStream zipInputStream = new ZipInputStream(zipStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                LOGGER.debug("Extracting RPM: {}", (Object)entry.getName());
                Path rpmPath = Paths.get("/tmp/rpms-linux64", entry.getName());
                try (FileOutputStream fos = new FileOutputStream(rpmPath.toFile());){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = zipInputStream.read(buffer)) != -1) {
                        fos.write(buffer, 0, bytesRead);
                    }
                }
                CloudHubRpmExtractor.extractSoFilesUsingLinuxTools(rpmPath);
                Files.deleteIfExists(rpmPath);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error extracting RPMs from /cloudhub-chrome-dependencies.zip", (Throwable)e);
        }
    }

    private static void extractSoFilesUsingLinuxTools(Path rpmPath) {
        try {
            LOGGER.debug("Running rpm2cpio and cpio to extract .so files from: {}", (Object)rpmPath);
            String command = String.format("rpm2cpio %s | cpio --extract --no-preserve-owner --make-directories --unconditional --verbose", rpmPath.toAbsolutePath());
            ProcessBuilder processBuilder = new ProcessBuilder("sh", "-c", command);
            processBuilder.directory(new File("/tmp/rpms-linux64"));
            processBuilder.redirectErrorStream(true);
            Process proc = processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    LOGGER.debug("Extracted: {}", (Object)line);
                }
            }
            int exitCode = proc.waitFor();
            if (exitCode != 0) {
                LOGGER.debug("Extraction failed with exit code: {}", (Object)exitCode);
            } else {
                LOGGER.debug("Extraction completed successfully.");
                CloudHubRpmExtractor.moveSoFilesToLibsDir();
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Error processing RPM: {}", (Object)rpmPath, (Object)e);
        }
    }

    private static void moveSoFilesToLibsDir() throws IOException {
        Files.walk(Paths.get("/tmp/rpms-linux64", new String[0]), new FileVisitOption[0]).filter(path -> path.toString().endsWith(".so") || path.toString().contains(".so.")).forEach(path -> {
            try {
                Path targetPath = Paths.get("/tmp/chrome-deps-linux64", path.getFileName().toString());
                Files.move(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
                LOGGER.debug("Moved: " + targetPath);
            }
            catch (IOException e) {
                LOGGER.error("Error moving file: " + path, (Object)e.getMessage());
            }
        });
    }
}

