/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.helper.webdriver;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.mule.extension.webcrawler.internal.helper.webdriver.CloudHubChromeConfigurer;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverManager.class);
    private static WebDriver driver;

    private WebDriverManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebDriver getDriver(String userAgent) throws IOException, InterruptedException {
        if (driver != null) return driver;
        Class<WebDriverManager> clazz = WebDriverManager.class;
        synchronized (WebDriverManager.class) {
            if (driver != null) return driver;
            driver = WebDriverManager.setupWebDriver(userAgent);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return driver;
        }
    }

    private static WebDriver setupWebDriver(String userAgent) throws IOException, InterruptedException {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--headless"});
        options.addArguments(new String[]{"--disable-gpu"});
        options.addArguments(new String[]{"--no-sandbox"});
        options.addArguments(new String[]{"--disable-dev-shm-usage"});
        options.addArguments(new String[]{"--allow-running-insecure-content"});
        if (!userAgent.isEmpty()) {
            options.addArguments(new String[]{"--user-agent=\"" + userAgent + "\""});
        }
        if (CloudHubChromeConfigurer.isCloudHubDeployment()) {
            CloudHubChromeConfigurer.setup();
            String tempDir = Files.createTempDirectory("chrome-profile", new FileAttribute[0]).toString();
            options.setBinary("/tmp/chrome-linux64/chrome-lib-wrapper");
            options.addArguments(new String[]{"--user-data-dir=" + tempDir});
        }
        driver = new ChromeDriver(options);
        return driver;
    }

    public static void quitDriver() {
        if (driver != null) {
            LOGGER.debug("Quitting Selenium WebDriver");
            driver.quit();
            driver = null;
        }
    }
}

