/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.mule.extension.webcrawler.internal.constant.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLUtils.class);
    private static final Set<String> VALID_EXTENSIONS;
    private static final int MAX_EXTENSION_LENGTH = 5;
    private static final Map<String, String> MIME_TYPES;

    public static boolean isDocumentUrl(String url) {
        if (url == null || url.isEmpty()) {
            return false;
        }
        try {
            String cleanUrl = url.split("[?#]")[0].toLowerCase(Locale.ENGLISH);
            if (cleanUrl.length() < 2) {
                return false;
            }
            int lastDotIndex = cleanUrl.lastIndexOf(46);
            if (lastDotIndex == -1 || lastDotIndex == cleanUrl.length() - 1) {
                return false;
            }
            String fileExtension = cleanUrl.substring(lastDotIndex + 1);
            if (fileExtension.length() > 5) {
                return false;
            }
            if (!fileExtension.matches("^[a-z0-9]+$")) {
                return false;
            }
            return VALID_EXTENSIONS.contains(fileExtension);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isReferenceLink(String baseUrl, String linkToCheck) {
        try {
            URI baseUri = URI.create(baseUrl);
            URI linkUri = URI.create(linkToCheck);
            return baseUri.getScheme().equals(linkUri.getScheme()) && baseUri.getHost().equals(linkUri.getHost()) && baseUri.getPath().equals(linkUri.getPath()) && linkUri.getFragment() != null;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Invalid URL: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean isExternalLink(String baseUrl, String linkToCheck) throws MalformedURLException {
        URL parsedUrl = new URL(baseUrl);
        String baseDomain = parsedUrl.getHost();
        return !linkToCheck.contains(baseDomain);
    }

    public static String extractAndDecodeUrl(String fullUrl) throws UnsupportedEncodingException, MalformedURLException {
        URL url = new URL(fullUrl);
        String query = url.getQuery();
        if (query != null) {
            String[] params;
            for (String param : params = query.split("&")) {
                String[] pair = param.split("=");
                if (pair.length != 2 || !"url".equals(pair[0])) continue;
                return URLDecoder.decode(pair[1], StandardCharsets.UTF_8.name());
            }
            return fullUrl;
        }
        return fullUrl;
    }

    public static String extractFileNameFromUrl(String url) {
        String fileName = url.substring(url.lastIndexOf("/") + 1, url.indexOf(63) > 0 ? url.indexOf(63) : url.length());
        return fileName.contains(".") ? fileName : fileName + ".jpg";
    }

    public static String detectMimeTypeFromFileName(String fileName) {
        String extension = URLUtils.getFileExtension(fileName);
        return MIME_TYPES.getOrDefault(extension.toLowerCase(), "application/octet-stream");
    }

    private static String getFileExtension(String path) {
        int lastDotIndex = path.lastIndexOf(46);
        if (lastDotIndex != -1 && lastDotIndex < path.length() - 1) {
            return path.substring(lastDotIndex + 1);
        }
        return "";
    }

    static {
        MIME_TYPES = new HashMap<String, String>();
        HashSet<String> extensions = new HashSet<String>();
        for (Constants.DocumentExtension ext : Constants.DocumentExtension.values()) {
            extensions.add(ext.name().toLowerCase(Locale.ENGLISH));
        }
        VALID_EXTENSIONS = Collections.unmodifiableSet(extensions);
        MIME_TYPES.put("jpg", "image/jpeg");
        MIME_TYPES.put("jpeg", "image/jpeg");
        MIME_TYPES.put("png", "image/png");
        MIME_TYPES.put("gif", "image/gif");
        MIME_TYPES.put("bmp", "image/bmp");
        MIME_TYPES.put("webp", "image/webp");
        MIME_TYPES.put("svg", "image/svg+xml");
        MIME_TYPES.put("pdf", "application/pdf");
        MIME_TYPES.put("txt", "text/plain");
        MIME_TYPES.put("html", "text/html");
        MIME_TYPES.put("xml", "application/xml");
        MIME_TYPES.put("json", "application/json");
        MIME_TYPES.put("mp4", "video/mp4");
        MIME_TYPES.put("mp3", "audio/mpeg");
        MIME_TYPES.put("wav", "audio/wav");
        MIME_TYPES.put("zip", "application/zip");
        MIME_TYPES.put("rar", "application/vnd.rar");
        MIME_TYPES.put("7z", "application/x-7z-compressed");
    }
}

