/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.crawler.mule;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.jsoup.nodes.Document;
import org.mule.extension.webcrawler.internal.constant.Constants;
import org.mule.extension.webcrawler.internal.crawler.Crawler;
import org.mule.extension.webcrawler.internal.helper.page.PageHelper;
import org.mule.extension.webcrawler.internal.helper.webdriver.WebDriverManager;
import org.mule.extension.webcrawler.internal.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleCrawler
extends Crawler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleCrawler.class);
    private static final String CRAWLED_IMAGES_FOLDER = "images/";
    private static final String CRAWLED_DOCUMENTS_FOLDER = "docs/";

    public MuleCrawler(String userAgent, String referrer, String originalUrl, int maxDepth, boolean restrictToPath, boolean dynamicContent, int delayMillis, boolean downloadImages, int maxImageNumber, boolean downloadDocuments, int maxDocumentNumber, String downloadPath, List<String> contentTags, boolean rawHtml, boolean getMetaTags) {
        super(userAgent, referrer, originalUrl, maxDepth, restrictToPath, dynamicContent, delayMillis, downloadImages, maxImageNumber, downloadDocuments, maxDocumentNumber, downloadPath, contentTags, rawHtml, getMetaTags);
    }

    @Override
    public Crawler.CrawlNode crawl() {
        this.visitedLinksGlobal = new HashSet();
        this.visitedLinksByDepth = new HashMap();
        return this.crawl(this.rootURL, 0, this.rootReferrer);
    }

    private Crawler.CrawlNode crawl(String url, int currentDepth, String referrer) {
        if (currentDepth > this.maxDepth) {
            return null;
        }
        if (this.restrictToPath && !url.startsWith(this.rootURL)) {
            LOGGER.debug("SKIPPING due to strict crawling: " + url);
            return null;
        }
        this.visitedLinksByDepth.putIfAbsent(currentDepth, new HashSet());
        if (((Set)this.visitedLinksByDepth.get(currentDepth)).contains(url)) {
            return null;
        }
        try {
            Utils.addDelay(this.delayMillis);
            ((Set)this.visitedLinksByDepth.get(currentDepth)).add(url);
            Crawler.CrawlNode crawlNode = null;
            Document document = null;
            document = this.dynamicContent ? PageHelper.getDocumentDynamic(url, this.userAgent, false) : PageHelper.getDocument(url, this.userAgent, referrer);
            if (!this.visitedLinksGlobal.contains(url)) {
                this.visitedLinksGlobal.add(url);
                JSONObject pageData = new JSONObject();
                LOGGER.debug("Fetching content for : " + url);
                String title = document.title();
                pageData.put("url", (Object)url);
                pageData.put("title", (Object)title);
                if (this.downloadImages) {
                    LOGGER.debug("Downloading images for : " + url);
                    pageData.put("imageFiles", (Object)PageHelper.downloadWebsiteImages(document, this.downloadPath, CRAWLED_IMAGES_FOLDER, this.maxImageNumber));
                }
                if (this.downloadDocuments) {
                    LOGGER.debug("Downloading documents for : " + url);
                    pageData.put("documentFiles", (Object)PageHelper.downloadFiles(document, this.downloadPath, CRAWLED_DOCUMENTS_FOLDER, this.maxDocumentNumber));
                }
                if (this.getMetaTags) {
                    JSONArray pageMetaTags = PageHelper.getPageMetaTags(document);
                    pageData.put("metaTags", (Object)pageMetaTags);
                }
                pageData.put("content", (Object)PageHelper.getPageContent(document, this.contentTags, this.rawHtml));
                String filename = PageHelper.savePageContents(pageData, this.downloadPath, title);
                crawlNode = new Crawler.CrawlNode(url, filename);
            } else {
                crawlNode = new Crawler.CrawlNode(url, "Duplicate.");
            }
            if (currentDepth <= this.maxDepth) {
                Set links = new HashSet();
                HashMap<String, Object> pageInsights = PageHelper.getPageInsights(document, null, Constants.PageInsightType.INTERNALLINKS);
                HashMap linksMap = (HashMap)pageInsights.get("links");
                if (linksMap != null) {
                    links = (Set)linksMap.get("internal");
                }
                if (links != null) {
                    for (String childURL : links) {
                        Crawler.CrawlNode childPageNode = this.crawl(childURL, currentDepth + 1, url);
                        if (childPageNode == null) continue;
                        crawlNode.addChild(childPageNode);
                    }
                }
            }
            return crawlNode;
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            WebDriverManager.quitDriver();
            return null;
        }
    }

    @Override
    public Crawler.MapNode map() {
        this.visitedLinksGlobal = new HashSet();
        this.visitedLinksByDepth = new HashMap();
        return this.map(this.rootURL, 0);
    }

    private Crawler.MapNode map(String url, int currentDepth) {
        if (currentDepth > this.maxDepth) {
            return null;
        }
        this.visitedLinksByDepth.putIfAbsent(currentDepth, new HashSet());
        if (((Set)this.visitedLinksByDepth.get(currentDepth)).contains(url)) {
            return null;
        }
        try {
            Utils.addDelay(this.delayMillis);
            ((Set)this.visitedLinksByDepth.get(currentDepth)).add(url);
            Crawler.MapNode node = null;
            Document document = PageHelper.getDocument(url, this.userAgent, this.rootReferrer);
            node = new Crawler.MapNode(url);
            LOGGER.debug("Found url: " + url);
            if (currentDepth <= this.maxDepth) {
                Map linksMap;
                HashMap<String, Object> pageInsights;
                Set links = new HashSet();
                if (this.restrictToPath) {
                    pageInsights = PageHelper.getPageInsights(document, null, Constants.PageInsightType.INTERNALLINKS);
                    linksMap = (Map)pageInsights.get("links");
                    if (linksMap != null) {
                        links = (Set)linksMap.get("internal");
                    }
                } else {
                    pageInsights = PageHelper.getPageInsights(document, null, Constants.PageInsightType.ALL);
                    linksMap = (Map)pageInsights.get("links");
                    if (linksMap != null) {
                        links.addAll((Set)linksMap.get("internal"));
                        links.addAll((Set)linksMap.get("external"));
                    }
                }
                if (links != null) {
                    for (String childURL : links) {
                        Crawler.MapNode childNode = currentDepth < this.maxDepth ? this.map(childURL, currentDepth + 1) : new Crawler.MapNode(childURL);
                        if (childNode == null) continue;
                        node.addChild(childNode);
                    }
                }
            }
            return node;
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            return null;
        }
    }
}

