/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.helper.webdriver;

import java.io.IOException;
import org.mule.extension.webcrawler.internal.helper.webdriver.CloudHubChromeConfigurer;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverManager.class);
    private static WebDriver driver;

    private WebDriverManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebDriver getDriver(String userAgent) throws IOException, InterruptedException {
        if (driver != null) return driver;
        Class<WebDriverManager> clazz = WebDriverManager.class;
        synchronized (WebDriverManager.class) {
            if (driver != null) return driver;
            driver = WebDriverManager.setupWebDriver(userAgent);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return driver;
        }
    }

    private static WebDriver setupWebDriver(String userAgent) {
        ChromeOptions options = new ChromeOptions();
        if (CloudHubChromeConfigurer.isCloudHubDeployment()) {
            CloudHubChromeConfigurer.setup();
            options.setBinary("/tmp/chrome-linux64/chrome-lib-wrapper");
        } else {
            options.addArguments(new String[]{"--headless"});
        }
        options.addArguments(new String[]{"--disable-gpu"});
        options.addArguments(new String[]{"--no-sandbox"});
        options.addArguments(new String[]{"--disable-dev-shm-usage"});
        options.addArguments(new String[]{"--allow-running-insecure-content"});
        if (!userAgent.isEmpty()) {
            options.addArguments(new String[]{"--user-agent=" + userAgent});
        }
        driver = new ChromeDriver(options);
        String actualUserAgent = (String)((JavascriptExecutor)driver).executeScript("return navigator.userAgent;", new Object[0]);
        LOGGER.info("User Agent: {}", (Object)actualUserAgent);
        return driver;
    }

    public static void quitDriver() {
        if (driver != null) {
            LOGGER.debug("Quitting Selenium WebDriver");
            driver.quit();
            driver = null;
        }
    }
}

