/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.operation;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.mule.extension.webcrawler.api.metadata.ResponseAttributes;
import org.mule.extension.webcrawler.internal.config.WebCrawlerConfiguration;
import org.mule.extension.webcrawler.internal.crawler.Crawler;
import org.mule.extension.webcrawler.internal.error.WebCrawlerErrorType;
import org.mule.extension.webcrawler.internal.error.provider.WebCrawlerErrorTypeProvider;
import org.mule.extension.webcrawler.internal.helper.ResponseHelper;
import org.mule.extension.webcrawler.internal.helper.parameter.CrawlerTargetContentParameters;
import org.mule.extension.webcrawler.internal.helper.parameter.CrawlerTargetPagesParameters;
import org.mule.extension.webcrawler.internal.util.JSONUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrawlOperations.class);

    @MediaType(value="application/json", strict=false)
    @Alias(value="crawl-website")
    @DisplayName(value="[Crawl] Website")
    @Throws(value={WebCrawlerErrorTypeProvider.class})
    @OutputJsonType(schema="api/metadata/CrawlWebSite.json")
    public Result<InputStream, ResponseAttributes> crawlWebsite(@Config WebCrawlerConfiguration configuration, final @DisplayName(value="Website URL") @Placement(order=1) @Example(value="https://mac-project.ai/docs") String url, @DisplayName(value="Download location") @Placement(order=2) @Example(value="/users/mulesoft/downloads") String downloadPath, @ParameterGroup(name="Target Pages") CrawlerTargetPagesParameters targetPagesParameters, @ParameterGroup(name="Target Content") CrawlerTargetContentParameters targetContentParameters) {
        try {
            LOGGER.debug("\n\n" + targetPagesParameters.toString() + "\n");
            LOGGER.debug("\n\n" + targetContentParameters.toString() + "\n");
            Crawler crawler = Crawler.builder().userAgent(configuration.getRequestParameters().getUserAgent()).rootReferrer(configuration.getRequestParameters().getReferrer()).delayMillis(configuration.getCrawlerSettingsParameters().getDelayMillis()).dynamicContent(configuration.getCrawlerSettingsParameters().isDynamicContent()).rawHtml(configuration.getCrawlerSettingsParameters().isRawHtml()).rootURL(url).downloadPath(downloadPath).maxDepth(targetPagesParameters.getMaxDepth()).restrictToPath(targetPagesParameters.isRestrictToPath()).contentTags(targetContentParameters.getTags()).getMetaTags(targetContentParameters.isGetMetaTags()).downloadImages(targetContentParameters.isDownloadImages()).maxImageNumber(targetContentParameters.getMaxImageNumber()).downloadDocuments(targetContentParameters.isDownloadDocuments()).maxDocumentNumber(targetContentParameters.getMaxDocumentNumber()).build();
            LOGGER.debug("Start website crawling");
            Crawler.CrawlNode rootNode = crawler.crawl();
            return ResponseHelper.createResponse(JSONUtils.convertToJSON(rootNode), (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("url", url);
                }
            });
        }
        catch (ModuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Error while crawling website '%s'.", url), (ErrorTypeDefinition)WebCrawlerErrorType.WEBCRAWLER_OPERATIONS_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="crawl-links-as-sitemap")
    @DisplayName(value="[Crawl] Get links as sitemap")
    @Throws(value={WebCrawlerErrorTypeProvider.class})
    @OutputJsonType(schema="api/metadata/CrawlGetLinksAsSitemap.json")
    public Result<InputStream, ResponseAttributes> getSiteMap(@Config WebCrawlerConfiguration configuration, final @DisplayName(value="Website URL") @Placement(order=1) @Example(value="https://mac-project.ai/docs") String url, @ParameterGroup(name="Target Pages") CrawlerTargetPagesParameters targetPagesParameters) {
        try {
            LOGGER.info("Generate sitemap");
            Crawler crawler = Crawler.builder().userAgent(configuration.getRequestParameters().getUserAgent()).rootReferrer(configuration.getRequestParameters().getReferrer()).rootURL(url).restrictToPath(targetPagesParameters.isRestrictToPath()).maxDepth(targetPagesParameters.getMaxDepth()).build();
            Crawler.MapNode root = crawler.map();
            return ResponseHelper.createResponse(JSONUtils.convertToJSON(root), (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("url", url);
                }
            });
        }
        catch (ModuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Error while generating sitemap for '%s'.", url), (ErrorTypeDefinition)WebCrawlerErrorType.WEBCRAWLER_OPERATIONS_FAILURE, (Throwable)e);
        }
    }
}

