/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.operation;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.jsoup.UnsupportedMimeTypeException;
import org.jsoup.nodes.Document;
import org.mule.extension.webcrawler.api.metadata.ResponseAttributes;
import org.mule.extension.webcrawler.internal.config.WebCrawlerConfiguration;
import org.mule.extension.webcrawler.internal.constant.Constants;
import org.mule.extension.webcrawler.internal.error.WebCrawlerErrorType;
import org.mule.extension.webcrawler.internal.error.provider.WebCrawlerErrorTypeProvider;
import org.mule.extension.webcrawler.internal.helper.ResponseHelper;
import org.mule.extension.webcrawler.internal.helper.page.PageHelper;
import org.mule.extension.webcrawler.internal.helper.parameter.PageTargetContentParameters;
import org.mule.extension.webcrawler.internal.util.JSONUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageOperations.class);

    @MediaType(value="application/json", strict=false)
    @Alias(value="page-meta-tags")
    @DisplayName(value="[Page] Get meta tags")
    @Throws(value={WebCrawlerErrorTypeProvider.class})
    @OutputJsonType(schema="api/metadata/PageGetMetaTags.json")
    public Result<InputStream, ResponseAttributes> getMetaTags(@Config WebCrawlerConfiguration configuration, final @DisplayName(value="Page URL") @Placement(order=1) @Example(value="https://mac-project.ai/docs") String url) {
        try {
            LOGGER.info("Get meta tags");
            Document document = !configuration.getCrawlerSettingsParameters().isDynamicContent() ? PageHelper.getDocument(url, configuration.getRequestParameters().getUserAgent(), configuration.getRequestParameters().getReferrer()) : PageHelper.getDocumentDynamic(url, configuration.getRequestParameters().getUserAgent(), true);
            return ResponseHelper.createResponse(PageHelper.getPageMetaTags(document).toString(), (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("url", url);
                }
            });
        }
        catch (ModuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Error while getting page meta tags from '%s'.", url), (ErrorTypeDefinition)WebCrawlerErrorType.WEBCRAWLER_OPERATIONS_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="page-download-image")
    @DisplayName(value="[Page] Download image")
    @Throws(value={WebCrawlerErrorTypeProvider.class})
    @OutputJsonType(schema="api/metadata/PageDownloadImage.json")
    public Result<InputStream, ResponseAttributes> downloadWebsiteImages(@Config WebCrawlerConfiguration configuration, final @DisplayName(value="Page or image URL") @Placement(order=1) @Example(value="https://mac-project.ai/docs") String url, @Alias(value="maxImageNumber") @DisplayName(value="Max number of images") @Summary(value="Maximum number of images to download. Default 0 means no limit.") @Placement(order=2) @Expression(value=ExpressionSupport.SUPPORTED) @Example(value="10") @Optional int maxImageNumber, @DisplayName(value="Download location") @Placement(order=3) @Example(value="/users/mulesoft/downloads") String downloadPath) {
        try {
            JSONArray imagesJSONArray = new JSONArray();
            try {
                Document document = !configuration.getCrawlerSettingsParameters().isDynamicContent() ? PageHelper.getDocument(url, configuration.getRequestParameters().getUserAgent(), configuration.getRequestParameters().getReferrer()) : PageHelper.getDocumentDynamic(url, configuration.getRequestParameters().getUserAgent(), true);
                imagesJSONArray = PageHelper.downloadWebsiteImages(document, downloadPath, maxImageNumber);
            }
            catch (UnsupportedMimeTypeException e) {
                imagesJSONArray.put((Object)PageHelper.downloadSingleImage(url, downloadPath));
            }
            return ResponseHelper.createResponse(imagesJSONArray.toString(), (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("url", url);
                }
            });
        }
        catch (ModuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Error while downloading image from '%s'.", url), (ErrorTypeDefinition)WebCrawlerErrorType.WEBCRAWLER_OPERATIONS_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="page-download-document")
    @DisplayName(value="[Page] Download document")
    @Throws(value={WebCrawlerErrorTypeProvider.class})
    @OutputJsonType(schema="api/metadata/PageDownloadDocument.json")
    public Result<InputStream, ResponseAttributes> downloadWebsiteDocuments(@Config WebCrawlerConfiguration configuration, final @DisplayName(value="Page or document URL") @Placement(order=1) @Example(value="https://mac-project.ai/docs") String url, @Alias(value="maxDocumentNumber") @DisplayName(value="Max number of documents") @Summary(value="Maximum number of documents to download. Default 0 means no limit.") @Placement(order=2) @Expression(value=ExpressionSupport.SUPPORTED) @Example(value="10") @Optional int maxDocumentNumber, @DisplayName(value="Download location") @Placement(order=3) @Example(value="/users/mulesoft/downloads") String downloadPath) {
        try {
            JSONArray documentsJSONArray = new JSONArray();
            try {
                Document document = !configuration.getCrawlerSettingsParameters().isDynamicContent() ? PageHelper.getDocument(url, configuration.getRequestParameters().getUserAgent(), configuration.getRequestParameters().getReferrer()) : PageHelper.getDocumentDynamic(url, configuration.getRequestParameters().getUserAgent(), true);
                documentsJSONArray = PageHelper.downloadFiles(document, downloadPath, maxDocumentNumber);
            }
            catch (UnsupportedMimeTypeException e) {
                documentsJSONArray.put((Object)PageHelper.downloadFile(url, downloadPath));
            }
            return ResponseHelper.createResponse(documentsJSONArray.toString(), (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("url", url);
                }
            });
        }
        catch (ModuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Error while downloading document from '%s'.", url), (ErrorTypeDefinition)WebCrawlerErrorType.WEBCRAWLER_OPERATIONS_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="page-insights")
    @DisplayName(value="[Page] Get insights")
    @Throws(value={WebCrawlerErrorTypeProvider.class})
    @OutputJsonType(schema="api/metadata/PageGetInsights.json")
    public Result<InputStream, ResponseAttributes> getPageInsights(@Config WebCrawlerConfiguration configuration, final @DisplayName(value="Page URL") @Placement(order=1) @Example(value="https://mac-project.ai/docs") String url, @ParameterGroup(name="Target Content") PageTargetContentParameters targetContentParameters) {
        try {
            LOGGER.info("Analyze page");
            Document document = !configuration.getCrawlerSettingsParameters().isDynamicContent() ? PageHelper.getDocument(url, configuration.getRequestParameters().getUserAgent(), configuration.getRequestParameters().getReferrer()) : PageHelper.getDocumentDynamic(url, configuration.getRequestParameters().getUserAgent(), true);
            return ResponseHelper.createResponse(JSONUtils.convertToJSON(PageHelper.getPageInsights(document, targetContentParameters.getTags(), Constants.PageInsightType.ALL)), (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("url", url);
                }
            });
        }
        catch (ModuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Error while getting page insights from '%s'.", url), (ErrorTypeDefinition)WebCrawlerErrorType.WEBCRAWLER_OPERATIONS_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="page-content")
    @DisplayName(value="[Page] Get content")
    @Throws(value={WebCrawlerErrorTypeProvider.class})
    @OutputJsonType(schema="api/metadata/PageGetContent.json")
    public Result<InputStream, ResponseAttributes> getPageContent(@Config WebCrawlerConfiguration configuration, final @DisplayName(value="Page URL") @Placement(order=1) @Example(value="https://mac-project.ai/docs") String url, @ParameterGroup(name="Target Content") PageTargetContentParameters targetContentParameters) {
        try {
            LOGGER.info("Get page content");
            HashMap<String, String> contents = new HashMap<String, String>();
            Document document = !configuration.getCrawlerSettingsParameters().isDynamicContent() ? PageHelper.getDocument(url, configuration.getRequestParameters().getUserAgent(), configuration.getRequestParameters().getReferrer()) : PageHelper.getDocumentDynamic(url, configuration.getRequestParameters().getUserAgent(), true);
            String content = PageHelper.getPageContent(document, targetContentParameters.getTags(), configuration.getCrawlerSettingsParameters().isRawHtml());
            contents.put("url", document.baseUri());
            contents.put("title", document.title());
            contents.put("content", content);
            return ResponseHelper.createResponse(JSONUtils.convertToJSON(contents), (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("url", url);
                }
            });
        }
        catch (ModuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Error while getting page content from '%s'.", url), (ErrorTypeDefinition)WebCrawlerErrorType.WEBCRAWLER_OPERATIONS_FAILURE, (Throwable)e);
        }
    }
}

