/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.connection.http;

import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.extension.webcrawler.internal.connection.WebCrawlerConnection;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection
implements WebCrawlerConnection {
    private static Logger LOGGER = LoggerFactory.getLogger(HttpConnection.class);
    private HttpClient httpClient;
    private String userAgent;
    private String referrer;
    private int timeout;

    public HttpConnection(HttpClient httpClient, int timeout, String userAgent, String referrer) {
        this.httpClient = httpClient;
        this.userAgent = userAgent;
        this.referrer = referrer;
        this.timeout = timeout;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public String getReferrer() {
        return this.referrer;
    }

    public boolean validate() throws ConnectionException {
        return true;
    }

    @Override
    public CompletableFuture<InputStream> getPageSource(String url) {
        return this.getPageSource(url, this.referrer);
    }

    @Override
    public CompletableFuture<InputStream> getPageSource(String url, String currentReferrer) {
        LOGGER.debug(String.format("Retrieving page source for url %s using http client", url));
        HttpRequestBuilder requestBuilder = HttpRequest.builder().method("GET").uri(url);
        if (this.userAgent != null) {
            requestBuilder.addHeader("User-Agent", this.userAgent);
        }
        if (currentReferrer != null) {
            requestBuilder.addHeader("Referrer", currentReferrer);
        }
        HttpRequest request = requestBuilder.build();
        HttpRequestOptions options = HttpRequestOptions.builder().responseTimeout(this.timeout != 0 ? this.timeout : 10000).build();
        return ((CompletableFuture)this.httpClient.sendAsync(request, options).thenApply(response -> {
            if (response.getStatusCode() == 200) {
                return response.getEntity().getContent();
            }
            throw new RuntimeException(String.format("%s: %s", response.getStatusCode(), response.getReasonPhrase()));
        })).exceptionally(e -> {
            throw new RuntimeException((Throwable)e);
        });
    }
}

