/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.connection.webdriver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.extension.webcrawler.internal.connection.WebCrawlerConnection;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.v132.network.Network;
import org.openqa.selenium.devtools.v132.network.model.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverConnection
implements WebCrawlerConnection {
    private static Logger LOGGER = LoggerFactory.getLogger(WebDriverConnection.class);
    private WebDriver driver;
    private String userAgent;
    private String referrer;

    public WebDriverConnection(WebDriver driver, String userAgent, String referrer) {
        this.driver = driver;
        this.userAgent = userAgent;
        this.referrer = referrer;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public String getReferrer() {
        return this.referrer;
    }

    @Override
    public CompletableFuture<InputStream> getPageSource(String url) {
        return this.getPageSource(url, this.referrer);
    }

    @Override
    public CompletableFuture<InputStream> getPageSource(String url, String currentReferrer) {
        LOGGER.debug(String.format("Retrieving page source for url %s using webdriver", url));
        return CompletableFuture.supplyAsync(() -> {
            if (currentReferrer != null && !currentReferrer.isEmpty() && !currentReferrer.equalsIgnoreCase(this.referrer)) {
                try {
                    DevTools devTools = ((ChromeDriver)this.driver).getDevTools();
                    devTools.createSession();
                    devTools.send(Network.enable(Optional.empty(), Optional.empty(), Optional.empty()));
                    devTools.send(Network.setExtraHTTPHeaders((Headers)new Headers(Map.of("Referer", currentReferrer))));
                }
                catch (Exception e) {
                    LOGGER.debug("Error while trying to set referer for web driver");
                }
            }
            this.driver.get(url);
            String pageSource = this.driver.getPageSource();
            return new ByteArrayInputStream(pageSource.getBytes(StandardCharsets.UTF_8));
        });
    }
}

