/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.pagination;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jsoup.nodes.Document;
import org.mule.extension.webcrawler.api.metadata.ResponseAttributes;
import org.mule.extension.webcrawler.internal.config.WebCrawlerConfiguration;
import org.mule.extension.webcrawler.internal.connection.WebCrawlerConnection;
import org.mule.extension.webcrawler.internal.constant.Constants;
import org.mule.extension.webcrawler.internal.crawler.Crawler;
import org.mule.extension.webcrawler.internal.error.WebCrawlerErrorType;
import org.mule.extension.webcrawler.internal.helper.ResponseHelper;
import org.mule.extension.webcrawler.internal.helper.page.PageHelper;
import org.mule.extension.webcrawler.internal.helper.parameter.CrawlerTargetPagesParameters;
import org.mule.extension.webcrawler.internal.util.JSONUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlerPagingProvider
implements PagingProvider<WebCrawlerConnection, Result<CursorProvider, ResponseAttributes>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrawlerPagingProvider.class);
    private Crawler crawler;
    private Iterator<Document> documentIterator;
    private WebCrawlerConfiguration configuration;
    private String url;
    private Constants.OutputFormat outputFormat;
    private CrawlerTargetPagesParameters targetPagesParameters;
    private StreamingHelper streamingHelper;

    public CrawlerPagingProvider(WebCrawlerConfiguration configuration, String url, Constants.OutputFormat outputFormat, CrawlerTargetPagesParameters targetPagesParameters, StreamingHelper streamingHelper) {
        this.configuration = configuration;
        this.url = url;
        this.outputFormat = outputFormat;
        this.targetPagesParameters = targetPagesParameters;
        this.streamingHelper = streamingHelper;
    }

    public List<Result<CursorProvider, ResponseAttributes>> getPage(WebCrawlerConnection connection) {
        try {
            if (this.crawler == null) {
                this.crawler = Crawler.builder().connection(connection).delayMillis(this.configuration.getCrawlerSettingsParameters().getDelayMillis()).outputFormat(this.outputFormat).rootURL(this.url).maxDepth(this.targetPagesParameters.getMaxDepth()).restrictToPath(this.targetPagesParameters.isRestrictToPath()).regexUrlsFilterLogic(this.targetPagesParameters.getRegexUrlsFilterLogic()).regexUrls(this.targetPagesParameters.getRegexUrls()).build();
                this.documentIterator = this.crawler.documentIterator();
            }
            while (this.documentIterator.hasNext()) {
                try {
                    Document document = this.documentIterator.next();
                    if (document == null) continue;
                    String pageContent = PageHelper.getPageContent(document, null, this.outputFormat);
                    HashMap<String, String> pageMap = new HashMap<String, String>();
                    pageMap.put("url", document.baseUri());
                    pageMap.put("title", document.title());
                    pageMap.put("content", pageContent);
                    return ResponseHelper.createPageResponse(JSONUtils.convertToJSON(pageMap, true), (Map<String, Object>)new HashMap<String, Object>(){
                        {
                            this.put("url", CrawlerPagingProvider.this.url);
                        }
                    }, this.streamingHelper);
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Error while getting page content. %s", e.getMessage()));
                }
            }
            return Collections.emptyList();
        }
        catch (ModuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Error while getting page from %s.", this.url), (ErrorTypeDefinition)WebCrawlerErrorType.CRAWL_OPERATIONS_FAILURE, (Throwable)e);
        }
    }

    public Optional<Integer> getTotalResults(WebCrawlerConnection connection) {
        return Optional.empty();
    }

    public boolean useStickyConnections() {
        return true;
    }

    public void close(WebCrawlerConnection connection) throws MuleException {
    }
}

