/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.util;

import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    public static int countWords(String text) {
        if (text == null || text.trim().isEmpty()) {
            return 0;
        }
        String[] words = text.trim().split("\\s+");
        return words.length;
    }

    public static String getSanitizedFilename(String title) {
        return title.replaceAll("[\\\\/:*?\"<>|]", "_").replaceAll(" ", "");
    }

    public static void addDelay(int delayMillis) {
        if (delayMillis > 0) {
            try {
                LOGGER.info("Adding delay of " + delayMillis + " ms before fetching contents for the next URL.");
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException e) {
                LOGGER.error("Thread interrupted during delay: " + e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    public static String convertHtmlToMarkdown(String html) {
        return FlexmarkHtmlConverter.builder().build().convert(html);
    }
}

