/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.config;

import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class PageLoadOptions {
    @Parameter
    @Alias(value="waitOnPageLoad")
    @DisplayName(value="Wait on page load (millisecs)")
    @Summary(value="The time to wait on page load (not available for HTTP connection)")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Example(value="1000")
    @Optional
    private Long waitOnPageLoad;
    @Parameter
    @Alias(value="waitForXPath")
    @DisplayName(value="Wait for XPath")
    @Summary(value="The XPath to wait for (not available for HTTP connection)")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Example(value="//body")
    @Optional
    private String waitForXPath;
    @Parameter
    @Alias(value="extractShadowDom")
    @DisplayName(value="Extract Shadow DOM")
    @Summary(value="Extract the Shadow DOM content (not available for HTTP connection)")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="false")
    private boolean extractShadowDom;
    @Parameter
    @Alias(value="shadowHostXPath")
    @DisplayName(value="Shadow Host(s) XPath")
    @Summary(value="Shadow host(s) to extract by XPath (not available for HTTP connection)")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Example(value="//results")
    @Optional
    private String shadowHostXPath;

    public PageLoadOptions() {
    }

    public PageLoadOptions(Long waitOnPageLoad, String waitForXPath, boolean extractShadowDom, String shadowHostXPath) {
        this.waitOnPageLoad = waitOnPageLoad;
        this.waitForXPath = waitForXPath;
        this.extractShadowDom = extractShadowDom;
        this.shadowHostXPath = shadowHostXPath;
    }

    public Long getWaitOnPageLoad() {
        return this.waitOnPageLoad;
    }

    public void setWaitOnPageLoad(Long waitOnPageLoad) {
        this.waitOnPageLoad = waitOnPageLoad;
    }

    public String getWaitForXPath() {
        return this.waitForXPath;
    }

    public void setWaitForXPath(String waitForXPath) {
        this.waitForXPath = waitForXPath;
    }

    public boolean isExtractShadowDom() {
        return this.extractShadowDom;
    }

    public void setExtractShadowDom(boolean extractShadowDom) {
        this.extractShadowDom = extractShadowDom;
    }

    public String getShadowHostXPath() {
        return this.shadowHostXPath;
    }

    public void setShadowHostXPath(String shadowHostXPath) {
        this.shadowHostXPath = shadowHostXPath;
    }
}

