/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.connection.webdriver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.mule.extension.webcrawler.internal.config.PageLoadOptions;
import org.mule.extension.webcrawler.internal.connection.WebCrawlerConnection;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.v132.network.Network;
import org.openqa.selenium.devtools.v132.network.model.Headers;
import org.openqa.selenium.support.ui.FluentWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverConnection
implements WebCrawlerConnection {
    private static Logger LOGGER = LoggerFactory.getLogger(WebDriverConnection.class);
    private WebDriver driver;
    private String userAgent;
    private String referrer;

    public WebDriverConnection(WebDriver driver, String userAgent, String referrer) {
        this.driver = driver;
        this.userAgent = userAgent;
        this.referrer = referrer;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public String getReferrer() {
        return this.referrer;
    }

    @Override
    public CompletableFuture<InputStream> getPageSource(String url, PageLoadOptions pageLoadOptions) {
        return this.getPageSource(url, this.referrer, pageLoadOptions);
    }

    @Override
    public CompletableFuture<InputStream> getPageSource(String url, String currentReferrer, PageLoadOptions pageLoadOptions) {
        LOGGER.debug(String.format("Retrieving page source for url %s using webdrive (wait %s millisec)", url, pageLoadOptions.getWaitOnPageLoad()));
        return CompletableFuture.supplyAsync(() -> {
            if (currentReferrer != null && !currentReferrer.isEmpty() && !currentReferrer.equalsIgnoreCase(this.referrer)) {
                try {
                    DevTools devTools = ((ChromeDriver)this.driver).getDevTools();
                    devTools.createSession();
                    devTools.send(Network.enable(Optional.empty(), Optional.empty(), Optional.empty()));
                    devTools.send(Network.setExtraHTTPHeaders((Headers)new Headers(Map.of("Referer", currentReferrer))));
                }
                catch (Exception e) {
                    LOGGER.debug("Error while trying to set referer for web driver");
                }
            }
            this.driver.get(url);
            this.waitOnPageLoad(pageLoadOptions.getWaitOnPageLoad(), pageLoadOptions.getWaitForXPath());
            String pageSource = this.driver.getPageSource();
            return new ByteArrayInputStream(pageSource.getBytes(StandardCharsets.UTF_8));
        });
    }

    private void waitOnPageLoad(Long waitOnPageLoad, final String waitForXPath) {
        if (waitOnPageLoad != null && waitOnPageLoad > 0L) {
            if (waitForXPath != null && waitForXPath.compareTo("") != 0) {
                LOGGER.debug(String.format("Wait until %s for %s milliseconds", waitForXPath, waitOnPageLoad));
                try {
                    new FluentWait((Object)this.driver).withTimeout(Duration.ofMillis(waitOnPageLoad)).pollingEvery(Duration.ofMillis(500L)).ignoring(NoSuchElementException.class).until((Function)new Function<WebDriver, Boolean>(){

                        @Override
                        public Boolean apply(WebDriver webDriver) {
                            try {
                                WebElement element = webDriver.findElement(By.xpath((String)waitForXPath));
                                return element != null;
                            }
                            catch (NoSuchElementException e) {
                                return false;
                            }
                        }
                    });
                }
                catch (TimeoutException e) {
                    LOGGER.warn(String.format("Element %s not found within the timeout period %s", waitForXPath, waitOnPageLoad));
                }
            } else {
                LOGGER.debug(String.format("Wait for %s milliseconds", waitOnPageLoad));
                try {
                    Thread.sleep(waitOnPageLoad);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void injectAllShadowDOMs(Document document, String shadowHostXPath) {
        JavascriptExecutor jsExecutor = (JavascriptExecutor)this.driver;
        if (shadowHostXPath == null) {
            shadowHostXPath = "//*";
        }
        List shadowHosts = this.driver.findElements(By.xpath((String)shadowHostXPath));
        for (WebElement shadowHost : shadowHosts) {
            Boolean hasShadowRoot = (Boolean)jsExecutor.executeScript("return arguments[0].shadowRoot !== null", new Object[]{shadowHost});
            if (!hasShadowRoot.booleanValue()) continue;
            String shadowContent = (String)jsExecutor.executeScript("return arguments[0].shadowRoot.innerHTML;", new Object[]{shadowHost});
            String tagName = shadowHost.getTagName();
            String jsoupXPath = tagName;
            Element jsoupElement = document.selectFirst(jsoupXPath);
            if (jsoupElement != null) {
                jsoupElement.append(shadowContent);
            }
            this.injectNestedShadowDOMs(jsExecutor, document, shadowHost);
        }
    }

    private void injectNestedShadowDOMs(JavascriptExecutor jsExecutor, Document document, WebElement shadowHost) {
        String shadowRootContent = (String)jsExecutor.executeScript("return arguments[0].shadowRoot ? arguments[0].shadowRoot.innerHTML : null;", new Object[]{shadowHost});
        if (shadowRootContent != null) {
            String tagName = shadowHost.getTagName();
            Element jsoupElement = document.selectFirst(tagName);
            if (jsoupElement != null) {
                jsoupElement.append(shadowRootContent);
            }
            List nestedElements = (List)jsExecutor.executeScript("return Array.from(arguments[0].shadowRoot.querySelectorAll('*'))", new Object[]{shadowHost});
            for (WebElement nestedElement : nestedElements) {
                this.injectNestedShadowDOMs(jsExecutor, document, nestedElement);
            }
        }
    }
}

